% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependencies}
\alias{dependencies}
\title{Find R Package Dependencies in a Project}
\usage{
dependencies(path = getwd(), root = NULL, quiet = FALSE)
}
\arguments{
\item{path}{The path to a (possibly multi-mode) \R file, or a directory
containing such files.}

\item{root}{The root directory to be used for dependency discovery.
Defaults to the active project directory. You may need to set this
explicitly to ensure that your project's \code{.renvignore}s (if any) are
properly handled.}

\item{quiet}{Boolean; report problems discovered (if any) during dependency
discovery?}
}
\value{
An \R \code{data.frame} of discovered dependencies, mapping inferred
package names to the files in which they were discovered.
}
\description{
Find \R packages used within a project.
}
\details{
\code{dependencies()} will crawl files within your project, looking for \R files
and the packages used within those \R files. This is done primarily by
parsing the code and looking for calls of the form:
\itemize{
\item \code{library(package)}
\item \code{require(package)}
\item \code{requireNamespace("package")}
\item \code{package::method()}
}

For \R package projects, dependencies expressed in the \code{DESCRIPTION} file
will also be discovered. Note that the \code{rmarkdown} package is required in
order to crawl dependencies in R Markdown files.
}
\section{Ignoring Files}{


By default, \code{renv} will read your project's \code{.gitignore}s (if any) to
determine whether certain files or folders should be included when traversing
directories. If preferred, you can also create a \code{.renvignore} file (with
entries of the same format as a standard \code{.gitignore} file) to tell \code{renv}
which files to ignore within a directory. If both \code{.renvignore} and
\code{.gitignore} exist within a folder, the \code{.renvignore} will be used in lieu of
the \code{.gitignore}.

See \url{https://git-scm.com/docs/gitignore} for documentation on the
\code{.gitignore} format. Some simple examples here:\preformatted{# ignore all R Markdown files
*.Rmd

# ignore all data folders
data/

# ignore only data folders from the root of the project
/data/
}
}

\examples{
\dontrun{

# find R package dependencies in the current directory
renv::dependencies()

}
}
