% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx.R
\name{to_pptx}
\alias{to_pptx}
\title{Render slides as pptx file.}
\usage{
to_pptx(
  from,
  to = NULL,
  density = 100,
  slides = "all",
  complex_slides = FALSE,
  partial_slides = FALSE,
  delay = 1,
  keep_intermediates = FALSE
)
}
\arguments{
\item{from}{Path to a Rmd file, html file, pdf file, or a url. If \code{from}
is a url to slides on a website, you must provide the full url
ending in \code{".html"}.}

\item{to}{Name of the output pptx file.}

\item{density}{Resolution of the resulting pngs in each slide file. Defaults
to \code{100}.}

\item{slides}{A numeric or integer vector of the slide number(s) to include
in the pptx, or one of \code{"all"}, \code{"first"}, or \code{"last"}. Negative integers
select which slides \emph{not} to include. Defaults to \code{"all"}, in which case
all slides are included.}

\item{complex_slides}{For "complex" slides (e.g. slides with panelsets or
other html widgets or advanced features), set \code{complex_slides = TRUE}.
Defaults to \code{FALSE}. This will use the {chromote} package to iterate
through the slides at a pace set by the \code{delay} argument. Requires a local
installation of Chrome.}

\item{partial_slides}{Should partial (continuation) slides be included in the
output? If \code{FALSE}, the default, only the complete slide is included in the
PDF.}

\item{delay}{Seconds of delay between advancing to and printing a new slide.
Only used if \code{complex_slides = TRUE} or \code{partial_slides = TRUE}.}

\item{keep_intermediates}{Should we keep the intermediate files used to
render the final output? The default is \code{FALSE}.}
}
\value{
Slides are rendered as a pptx file.
}
\description{
Render slides as a pptx file. The function renders to the pdf and
then converts it into png images that are inserted on each slide in the
pptx file.
}
\examples{
if (requireNamespace("officer", quietly = TRUE)) {
    with_example("slides.Rmd", {
        # Render pptx from Rmd, html, pdf, or direct URL
        to_pptx("slides.Rmd")
    })
}
}
