% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{to_png}
\alias{to_png}
\title{Render slides as png file(s).}
\usage{
to_png(
  from,
  to = NULL,
  density = 100,
  slides = 1,
  complex_slides = FALSE,
  partial_slides = FALSE,
  delay = 1,
  keep_intermediates = FALSE
)
}
\arguments{
\item{from}{Path to a Rmd file, html file, pdf file, or a url. If \code{from}
is a url to slides on a website, you must provide the full url
ending in \code{".html"}.}

\item{to}{Name of the output png or zip file.}

\item{density}{Resolution of the resulting pngs in each slide file. Defaults
to \code{100}.}

\item{slides}{A numeric or integer vector of the slide number(s) to render
as png files , or one of \code{"all"}, \code{"first"}, or \code{"last"}. Negative integers
select which slides \emph{not} to include. If more than one slide are included,
pngs will be returned as a zip file. Defaults to \code{"all"}, in which case
all slides are included.}

\item{complex_slides}{For "complex" slides (e.g. slides with panelsets or
other html widgets or advanced features), set \code{complex_slides = TRUE}.
Defaults to \code{FALSE}. This will use the {chromote} package to iterate
through the slides at a pace set by the \code{delay} argument. Requires a local
installation of Chrome.}

\item{partial_slides}{Should partial (continuation) slides be included in the
output? If \code{FALSE}, the default, only the complete slide is included in the
PDF.}

\item{delay}{Seconds of delay between advancing to and printing a new slide.
Only used if \code{complex_slides = TRUE} or \code{partial_slides = TRUE}.}

\item{keep_intermediates}{Should we keep the intermediate files used to
render the final output? The default is \code{FALSE}.}
}
\value{
Slides are rendered as a png file (single) or zip file of multiple
png files.
}
\description{
Render png image(s) of slides. The function renders to the pdf and
then converts it into png files of each slide. The slide numbers defined by
the \code{slides} argument are saved (defaults to \code{1}, returning only the title
slide). If \code{length(slides) > 1}, it will return the png files in a zip file.
You can also get a zip file of all the slides as pngs by setting \code{slides = "all"}).
}
\examples{
with_example("slides.Rmd", {
    # By default a png of only the first slide is built
    to_png("slides.Rmd", keep_intermediates = TRUE)

    # or render a zip file of multiple or all slides (`slides = "all"`)
    to_png("slides.pdf", slides = c(1, 3, 5))
})
}
