% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.r
\name{server}
\alias{server}
\title{Server Launcher}
\usage{
server(port = 55555, log = TRUE, password = NULL, maxretry = 5,
  checkversions = TRUE, showmsg = FALSE)
}
\arguments{
\item{port}{The port (number) that will be used for communication between 
the client and server.  The port value for the client and server
must agree.}

\item{log}{Logical; enables some basic logging in the server.}

\item{password}{A password the client must enter before the user can process
commands on the server.  If the value is \code{NULL}, then no
password checking takes place.}

\item{maxretry}{The maximum number of retries for passwords before shutting
everything down.}

\item{checkversions}{Logical; should a version check (pbdZMQ and remoter) be enforced?}

\item{showmsg}{Logical; if TRUE, turns on the "debug mode" for the server,
and prints messages in the server terminal.}
}
\value{
Returns \code{TRUE} invisibly on successful exit.
}
\description{
Launcher for the remoter server.
}

