% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rehydratoR.R
\name{rehydratoR}
\alias{rehydratoR}
\title{Get tweets for given statuses (tweet IDs).}
\usage{
rehydratoR(consumer_key, consumer_secret, access_token, access_secret,
  status_ids, base_path = NULL, group_start = 1)
}
\arguments{
\item{consumer_key}{Consumer Key (API Key) from https://apps.twitter.com/}

\item{consumer_secret}{Consumer Secret (API Secret) from https://apps.twitter.com/}

\item{access_token}{Access Token from the https://apps.twitter.com/}

\item{access_secret}{Access Token Secret from https://apps.twitter.com/}

\item{status_ids}{data frame of tweet IDs}

\item{base_path}{optional. The base path to use to save the tweets. If set, the function will
write the tweets to files instead of returning the tweets as a variable.}

\item{group_start}{is the group to start at after splitting list of ids.  Is useful in case the download was interrupted.}
}
\value{
A tibble of tweets data if base_path is not defined. Nothing is returned if base_path is defined
  but the tweets are saved to a file for about every 90,0000 tweets.
}
\description{
Get tweets for given statuses (tweet IDs).
}
\examples{
\dontrun{
# Get Twitter api keys from https://apps.twitter.com
consumerKey <- ''
consumerSecret <- ''
accessToken <- ''
accessTokenSecret <- ''

# Read tweet ids
tweet_ids <- data.frame(read.table(tweet_ids_file, numerals = 'no.loss'))

# Download tweets
tweets <- rehydratoR(consumerKey, consumerSecret, accessToken, accessTokenSecret, tweet_ids)
}

}
