% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_country_code.R
\name{get_country_code}
\alias{get_country_code}
\title{Get Country Code Of Regions}
\usage{
get_country_code(geo, typology = "NUTS")
}
\arguments{
\item{geo}{A character variable with geo codes.}

\item{typology}{Currently the following typologies are supported:
\code{"NUTS1"}, \code{"NUTS2"}, \code{"NUTS3"} or \code{"NUTS"} for any of
the NUTS typologies. The technical typology \code{"NUTS0"}
can be used to translate Eurostat country codes to ISO 3166-1 alpha-2
country codes.}
}
\value{
The ISO 3166-1 alpha-2 codes of the countries as a character
vector.
}
\description{
The function identifies the sub-national geographical identifiers from
known typologies and returns the ISO 3166-1 alpha-2 country codes.
}
\examples{
{
get_country_code (c("EL", "GR", "DED", "HU102"))
}
}
\seealso{
Other recode functions: 
\code{\link{recode_nuts}()}
}
\concept{recode functions}
