% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_model.R
\name{graph_model_q}
\alias{graph_model_q}
\title{Graph fitted model interactions.}
\usage{
graph_model_q(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm', 'glm', 'lme', or 'merMod'.}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
A ggplot2 graph of the plotted variables in the model.
}
\description{
\code{graph_model_q} provides an easy way to graph interactions in fitted
models. Selected variables will be graphed at +/- 1 SD (if continuous) or at
each level of the factor (if categorical).
}
\details{
Note that in most cases it is easier to use \code{\link{graph_model}} and
pass variable names in directly instead of strings of variable names.
\code{graph_model_q} uses standard evaluation in cases where such
evaluation is easier.
}
\examples{
# iris data
model <- lm(Sepal.Width ~ Sepal.Length * Species, data=iris)
graph_model_q(model, y='Sepal.Width', x='Sepal.Length', lines='Species')
}
\seealso{
\code{\link{graph_model.lm}}, \code{\link{graph_model.glm}}
}

