% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reading_time.R
\name{get_reading_time}
\alias{get_reading_time}
\title{get_reading_time}
\usage{
get_reading_time(
  series = 2,
  jurisdiction,
  year,
  document_type = 1,
  summary = TRUE,
  date_is_range = TRUE,
  country = FALSE,
  agency = NULL,
  cluster = NULL,
  label = NULL,
  industry = NULL,
  filtered = TRUE,
  label_level = 3,
  industry_level = NULL,
  label_source = "NAICS",
  version = NULL,
  download = FALSE,
  page = NULL,
  date = NULL,
  verbose = 0
)
}
\arguments{
\item{series}{Series ID (s), default value is 2 here}

\item{jurisdiction}{ID for the jurisdiction}

\item{year}{Year(s) of data}

\item{document_type}{ID for type of document, default value of 1}

\item{summary}{Return summary instead of document level data
(only one year of data is allowed for document level data),
default value is TRUE}

\item{date_is_range}{Indicating whether the time parameter is range or
should be treated as single data points,
default value is TRUE}

\item{country}{Get values for all subjurisdictions, default value is FALSE}

\item{agency}{Agency ID, default value is NULL}

\item{cluster}{Cluster ID}

\item{label}{Industry code using the jurisdiction-specific coding system
(returns all 3-digit industries by default),
default value is NULL}

\item{industry}{industry is deprecated; use label}

\item{filtered}{Exclude poorly-performing industry results
(use of unfiltered results is NOT recommended),
default value is TRUE}

\item{label_level}{Level of NAICS industries to include, default value is 3}

\item{industry_level}{industry_level is deprecated; use label_level}

\item{label_source}{classification standard (NAICS, BEA, SOC),
default value of "NAICS"}

\item{version}{Version ID for datasets with multiple versions
(if no ID is given, returns most recent version),
  default value is NULL}

\item{download}{If not False, a path location for a downloaded csv
of the results, default value is FALSE}

\item{page}{Page Number of the Response, default value is NULL}

\item{date}{date is deprecated, use year now}

\item{verbose}{Print out the url of the API call (useful for debugging),
default value is 0}
}
\value{
Returns pandas dataframe with the metadata
}
\description{
Convert word counts to total reading time
}
\examples{
\dontrun{get_reading_time(
  jurisdiction = 45,
  year = array(c(2022, 2023))
)}
}
