% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bivRegion.R
\name{plot.bivRegion}
\alias{plot.bivRegion}
\title{Plot a bivRegion object}
\usage{
\method{plot}{bivRegion}(
  x,
  tau = 0.95,
  newdata = NULL,
  reg.col = NULL,
  reg.lwd = 1,
  reg.lty = NULL,
  axes = TRUE,
  axes.col = "black",
  axes.lwd = 2L,
  cond = FALSE,
  add = FALSE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{A bivRegion object.}

\item{tau}{A number, or vector, defining the desired coverage(s) of the bivariate reference region.}

\item{newdata}{If cond=FALSE, a data.frame with new values to be depicted in
the standarized residuals scale. If cond=TRUE, a data frame containing covariate
values for which the reference/probabilistic region will be depicted.}

\item{reg.col}{Region line colour, in case of more than one tau it can be a vector.}

\item{reg.lwd}{Region line width, in case of more than one tau it can be a vector.}

\item{reg.lty}{Region line type, in case of more than one tau it can be a vector.}

\item{axes}{Logical; if TRUE (and cond=FALSE), vertical and horizontal lines
are added indicating four quadrants in the model residuals scale.}

\item{axes.col}{Axes colour.}

\item{axes.lwd}{Axes line width.}

\item{cond}{A logical argument, if TRUE a conditional reference region is depicted.}

\item{add}{A logical argument, if TRUE the conditional reference region is depicted over a pre existing plot.}

\item{legend}{A logical argument, if TRUE a legend is given along with the reference region.}

\item{...}{Further plot parameters.}
}
\value{
This function return a graphical representation for a bivRegion object.
}
\description{
This function allow to depict the estimated bivariate reference/probabilistic region, in
the estandarized residuals scale (cond=FALSE), or for any covariate value (cond=TRUE).
}
\examples{
Y = cbind(rnorm(100),rnorm(100))
Y = as.data.frame(Y)
names(Y) = c("y1","y2")
reg = bivRegion(Y,tau=0.95,shape=2)
plot(reg)
}
