% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hiredis.R
\name{hiredis}
\alias{hiredis}
\alias{redis_available}
\title{Interface to Redis}
\usage{
hiredis(..., version = NULL)

redis_available(...)
}
\arguments{
\item{...}{Named configuration options passed to
\code{\link{redis_config}}, used to create the environment
(notable keys include \code{host}, \code{port}, and the
environment variable \code{REDIS_URL}).  For
\code{redis_available}, arguments are passed through to
\code{hiredis}.}

\item{version}{Version of the interface to generate.  If given as
a string ot numeric version, then only commands that exist up to
that version will be included.  If given as \code{TRUE}, then we
will query the Redis server (with \code{INFO}) and extract the
version number that way.}
}
\description{
Create an interface to Redis, with a generated interface to all
Redis commands.
}
\examples{
# Only run if a Redis server is running
if (redux::redis_available()) {
  r <- redux::hiredis()
  r$PING()
  r$SET("foo", "bar")
  r$GET("foo")

  # There are lots of methods here:
  r
}
}
