% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node.R
\docType{methods}
\name{getNodeType}
\alias{getNodeType}
\alias{getNodeType,Node-method}
\title{Determine the node type and return as a string}
\usage{
getNodeType(.Object)

\S4method{getNodeType}{Node}(.Object)
}
\arguments{
\item{.Object}{a Node object}
}
\value{
a character vector containing the Node type
}
\description{
A Node has a type that is assigned at initialization and can have one of the following values:
'resource', 'literal', 'blank' and 'unknown'.
}
\examples{
world <- new("World")
node <- new("Node", world, uri="http://www.example.com")
nodeType <- getNodeType(node)
}

