% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{prec_cooccurrence}
\alias{prec_cooccurrence}
\title{Compute a matrix of precinct co-occurrences}
\usage{
prec_cooccurrence(plans, which = NULL, sampled_only = TRUE, ncores = 1)
}
\arguments{
\item{plans}{a \link{redist_plans} object.}

\item{which}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} which plans to
compute the co-occurrence over.  Defaults to all.}

\item{sampled_only}{if \code{TRUE}, do not include reference plans.}

\item{ncores}{the number of parallel cores to use in the computation.}
}
\value{
a symmetric matrix the size of the number of precincts.
}
\description{
For a map with \code{n} precincts Returns an \code{n}-by-\code{n} matrix, where each
entry measures the fraction of the plans in which the row and column
precincts were in the same district.
}
\concept{analyze}
