% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{plans_diversity}
\alias{plans_diversity}
\title{Calculate the diversity of a set of plans}
\usage{
plans_diversity(plans, n_max = 100, ncores = 1)
}
\arguments{
\item{plans}{a \code{\link{redist_plans}} object.}

\item{n_max}{the maximum number of plans to sample in computing the
distances. Larger numbers will have less sampling error but will require
more computation time.}

\item{ncores}{the number of cores to use in computing the distances.}
}
\value{
A numeric vector of off-diagonal variation of information distances.
}
\description{
Returns the off-diagonal elements of the variation of information distance
matrix for a sample of plans, which can be used as a diagnostic measure to
assess the diversity of a set of plans. If there are many values close to zero,
then the sample has many similar plans and may not be a good approximation
to the target distribution.
}
\examples{
data(iowa)
ia <- redist_map(iowa, existing_plan=cd_2010, pop_tol=0.01)
plans <- redist_smc(ia, 100, silent=TRUE)
hist(plans_diversity(plans))

}
\concept{analyze}
