% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counties.R
\name{redist.county.relabel}
\alias{redist.county.relabel}
\title{Relabel Discontinuous Counties}
\usage{
redist.county.relabel(adj, counties, simplify = TRUE, adjacency)
}
\arguments{
\item{adj}{adjacency list}

\item{counties}{character vector of county names}

\item{simplify}{boolean - TRUE returns a numeric vector of ids, while FALSE 
appends a number when there are multiple connected components.}

\item{adjacency}{Deprecated, use adj. adjacency list}
}
\value{
character vector of county names
}
\description{
Relabel Discontinuous Counties
}
\examples{
\dontrun{

set.seed(2)
counties <- sample(c(rep('a', 20), rep('b', 5)))
redist.relabel.counties(counties)

}
}
\concept{prepare}
