% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportReports.R
\name{exportReports}
\alias{exportReports}
\alias{exportReports.redcapDbConnection}
\alias{exportReports.redcapApiConnection}
\title{Export Reports from a REDCap Database}
\usage{
exportReports(rcon, report_id, factors = TRUE, labels = TRUE,
  dates = TRUE, checkboxLabels = FALSE, ...)

\method{exportReports}{redcapDbConnection}(rcon, report_id, factors = TRUE,
  labels = TRUE, dates = TRUE, checkboxLabels = FALSE, ...)

\method{exportReports}{redcapApiConnection}(rcon, report_id, factors = TRUE,
  labels = TRUE, dates = TRUE, checkboxLabels = FALSE, ...,
  bundle = getOption("redcap_bundle"),
  error_handling = getOption("redcap_error_handling"))
}
\arguments{
\item{rcon}{A REDCap connection object as created by \code{redcapConnection}.}

\item{report_id}{Integer.  Gives the report id of the desired report. 
This is located on the Report Builder page of the user interface on REDCap.}

\item{factors}{Logical.  Determines if categorical data from the database 
is returned as numeric codes or labelled factors.}

\item{labels}{Logical.  Determines if the variable labels are applied to the data frame.}

\item{dates}{Logical. Determines if date variables are converted to POSIXlt format during the download.}

\item{checkboxLabels}{Logical. Determines the format of labels in checkbox 
variables.  If \code{FALSE} labels are applies as "Unchecked"/"Checked".  
If \code{TRUE}, they are applied as ""/"[field_labe]" where [field_label] 
is the label assigned to the level in the data dictionary. This option 
is only available after REDCap version 6.0.}

\item{...}{Additional arguments to be passed between methods.}

\item{bundle}{A \code{redcapBundle} object as created by \code{exportBundle}.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
Exports reports from a REDCap Database and formats data if requested
}
\details{
A record of exports through the API is recorded in the Logging section of 
the project.

Reports are exported based on their id number, which can be looked up in 
the Reports page of a project
}
\section{REDCap API Documentation (6.5.0)}{

This function allows you to export the data set of a report created on a project's 
"Data Exports, Reports, and Stats" page.

Note about export rights (6.0.0+): Please be aware that Data Export user rights will be 
applied to this API request. For example, if you have "No Access" data export rights 
in the project, then the API report export will fail and return an error. And if you 
have "De-Identified" or "Remove all tagged Identifier fields" data export rights, 
then some data fields *might* be removed and filtered out of the data set returned 
from the API. To make sure that no data is unnecessarily filtered out of your API 
request, you should have "Full Data Set" export rights in the project.
}

\section{REDCap Version}{

6.0.0+
}

\section{Known REDCap Limitations}{

None
}

\author{
Benjamin Nutter
}
