## ----setup, echo = 3:4--------------------------------------------------------
knitr::opts_chunk$set(comment = "")
head <- utils::head
library(reda)
packageVersion("reda")

## ----ex-1---------------------------------------------------------------------
ex1 <- Recur(3:5)
head(ex1)

## ----ex-2---------------------------------------------------------------------
ex2 <- Recur(6:1, id = rep(1:2, 3))
head(ex2)
## sort by id, time2, and - event
head(ex2[ex2@ord, ])

## ----ex-3---------------------------------------------------------------------
left <- c(1, 5, 7)
right <- c(3, 7, 9)
ex3 <- Recur(left %to% right, id = c("A1", "A1", "A2"))
head(ex3)

## ----ex-4---------------------------------------------------------------------
ex4 <- Recur(list(time1 = left, time2 = right), id = c("A1", "A1", "A2"))
stopifnot(all.equal(ex3, ex4))

## ----ex-5---------------------------------------------------------------------
ex5 <- Recur(3:5, origin = 1, terminal = 1)
head(ex5)

## ----ex-6---------------------------------------------------------------------
ex6 <- Recur(3:5, id = c("A1", "A1", "A2"), origin = 1:2, terminal = c(0, 1))
head(ex6)

## ----ex-7---------------------------------------------------------------------
ex7 <- Recur(3:5, id = c("A1", "A1", "A2"),
             origin = c(1, 1, 2), terminal = c(0, 0, 1))
stopifnot(all.equal(ex6, ex7))

## ----origin-terminal-err------------------------------------------------------
try(Recur(1:10, origin = c(1, 2)))
try(Recur(1:10, terminal = c(1, 2)))

## ----rule1--------------------------------------------------------------------
try(Recur(1:5, id = c(rep("A1", 3), "A2", "A3"), event = c(0, 0, 1, 0, 0)))

## ----rule2--------------------------------------------------------------------
try(Recur(1:3, id = rep("A1", 3), terminal = c(0, 1, 1)))

## ----rule4--------------------------------------------------------------------
try(Recur(c(1:2, NA), id = rep("A1", 3)))

## ----rule5--------------------------------------------------------------------
try(Recur(3:5, id = rep("A1", 3), origin = 10))
try(Recur(3:5 %to% 1:3, id = rep("A1", 3)))

## ----rule6--------------------------------------------------------------------
try(Recur(c(0, 3, 5) %to% c(1, 6, 10), id = rep("A1", 3)))

## ----rule3--------------------------------------------------------------------
Recur(c(0, 2, 6) %to% c(1, 3, 8), id = rep("A1", 3), event = c(0, 1, 0))

## ----show1--------------------------------------------------------------------
set.seed(123)
term_events <- rbinom(length(unique(valveSeats$ID)), 1, 0.5)
with(valveSeats, Recur(Days, ID, No., term_events))

## ----show-na------------------------------------------------------------------
Recur(c(NA, 3:6, NA), id = rep(1:2, 3), check = "none")

## ----show-dig1----------------------------------------------------------------
op <- options()
getOption("digits")
Recur(pi, 1)

## ----show-dig2----------------------------------------------------------------
options(digits = 10)
Recur(pi, 1)
options(op) # reset (all) initial options

