% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_recolorize.R
\name{plot.recolorize}
\alias{plot.recolorize}
\title{Plot recolorized image results}
\usage{
\method{plot}{recolorize}(x, ..., plot_original = TRUE, horiz = TRUE, cex_text = 2, sizes = FALSE)
}
\arguments{
\item{x}{An object of class \code{recolorize}, such as
returned by \code{\link{recolorize}}, \code{\link{recluster}},
\code{\link{imposeColors}}, etc.}

\item{...}{further arguments passed to \code{plot}.}

\item{plot_original}{Logical. Plot the original image for comparison?}

\item{horiz}{Logical. Should plots be stacked vertically or horizontally?}

\item{cex_text}{Text size for printing color indices. Plotting parameters
passed to \code{\link{recolorize}{plotColorPalette}}.}

\item{sizes}{Logical. If \code{TRUE}, color palette is plotted proportional
to the size of each color. If \code{FALSE}, all colors take up an equal
amount of space, and their indices are printed for reference.}
}
\value{
No return value; plots the original image, recolored image, and
color palette.
}
\description{
S3 plotting method for objects of class \code{recolorize}. Plots a side-by-side
comparison of an original image and its recolorized version, plus the color
palette used for recoloring.
}
\examples{
corbetti <- system.file("extdata/corbetti.png",
                         package = "recolorize")

corbetti_recolor <- recolorize(corbetti, method = "hist",
                                         bins = 2, plotting = FALSE)

# unscaled color palette
plot(corbetti_recolor)

# scaled color palette
plot(corbetti_recolor, sizes = TRUE)

}
