% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string2factor.R
\name{step_string2factor}
\alias{step_string2factor}
\alias{tidy.step_string2factor}
\title{Convert Strings to Factors}
\usage{
step_string2factor(recipe, ..., role = NA, trained = FALSE, levels = NULL,
  ordered = FALSE, skip = FALSE)

\method{tidy}{step_string2factor}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will converted to factors. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{levels}{An options specification of the levels to be used
for the new factor. If left \code{NULL}, the sorted unique
values present when \code{bake} is called will be used.}

\item{ordered}{A single logical value; should the factor(s) be
ordered?}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{x}{A \code{step_string2factor} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{ordered}.
}
\description{
\code{step_string2factor} will convert one or more character
vectors to factors (ordered or unordered).
}
\details{
If \code{levels} is given, \code{step_string2factor} will
convert all factors to have the same levels. Also, note that
\code{prep} has an option \code{stringsAsFactors} that defaults
to \code{TRUE}. This should be changed so that raw character
data will be applied to \code{step_string2factor}.
}
\examples{
data(okc)

rec <- recipe(~ diet + location, data = okc)

make_factor <- rec \%>\%
  step_string2factor(diet)
make_factor <- prep(make_factor,
                    training = okc,
                    stringsAsFactors = FALSE,
                    retain = TRUE)

# note that `diet` is a factor
juice(make_factor) \%>\% head
okc \%>\% head
tidy(make_factor, number = 1)
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}} \code{\link[=step_dummy]{step_dummy()}} \code{\link[=step_other]{step_other()}}
\code{\link[=step_novel]{step_novel()}}
}
\concept{
preprocessing variable_encodings factors
}
\keyword{datagen}
