% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.recipe}
\alias{tidy.recipe}
\alias{tidy.step}
\alias{tidy.check}
\title{Tidy the Result of a Recipe}
\usage{
\method{tidy}{recipe}(x, number = NA, id = NA, ...)

\method{tidy}{step}(x, ...)

\method{tidy}{check}(x, ...)
}
\arguments{
\item{x}{A \code{recipe} object (trained or otherwise).}

\item{number}{An integer or \code{NA}. If missing and \code{id} is not provided,
the return value is a list of the operations in the recipe.
If a number is  given, a \code{tidy} method is executed for that operation
in the recipe (if it exists). \code{number} must not be provided if
\code{id} is.}

\item{id}{A character string or \code{NA}. If missing and \code{number} is not provided,
the return value is a list of the operations in the recipe.
If a character string is given, a \code{tidy} method is executed for that
operation in the recipe (if it exists). \code{id} must not be provided
if \code{number} is.}

\item{...}{Not currently used.}
}
\value{
A tibble with columns that would vary depending on what
\code{tidy} method is executed. When \code{number} and \code{id} are \code{NA}, a
tibble with columns \code{number} (the operation iteration),
\code{operation} (either "step" or "check"),
\code{type} (the method, e.g. "nzv", "center"), a logical
column called \code{trained} for whether the operation has been
estimated using \code{prep}, a logical for \code{skip}, and a character column \code{id}.
}
\description{
\code{tidy} will return a data frame that contains information
regarding a recipe or operation within the recipe (when a \code{tidy}
method for the operation exists).
}
\examples{
library(modeldata)
data(okc)

okc_rec <- recipe(~ ., data = okc) \%>\%
  step_other(all_nominal(), threshold = 0.05, other = "another") \%>\%
  step_date(date, features = "dow") \%>\%
  step_center(all_numeric()) \%>\%
  step_dummy(all_nominal()) \%>\%
  check_cols(starts_with("date"), age, height)

tidy(okc_rec)

tidy(okc_rec, number = 2)
tidy(okc_rec, number = 3)

okc_rec_trained <- prep(okc_rec, training = okc)

tidy(okc_rec_trained)
tidy(okc_rec_trained, number = 3)
}
