% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/grouping-and-repetition.R
\name{repeated}
\alias{lazy}
\alias{one_or_more}
\alias{optional}
\alias{repeated}
\alias{zero_or_more}
\title{Repeat values}
\usage{
repeated(x, lo, hi, lazy = FALSE)

optional(x)

lazy(x)

zero_or_more(x)

one_or_more(x)
}
\arguments{
\item{x}{A character vector.}

\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{lazy}{A logical value.  Should repetition be matched lazily or
greedily?}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match repeated values.
}
\examples{
x <- graph()
optional(x)
zero_or_more(x)
repeated(x, 0, Inf) # same
one_or_more(x)
repeated(x, 1, Inf) # same
repeated(x, 0)
repeated(x, 1)
repeated(x, 3)
repeated(x, 3, 5)
}
\references{
\url{http://www.regular-expressions.info/repeat.html}
}

