% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{SpecialCharacters}
\alias{BACKSLASH}
\alias{CARET}
\alias{CLOSE_PAREN}
\alias{DOLLAR}
\alias{DOT}
\alias{OPEN_BRACE}
\alias{OPEN_BRACKET}
\alias{OPEN_PAREN}
\alias{PIPE}
\alias{PLUS}
\alias{QUESTION}
\alias{STAR}
\alias{SpecialCharacters}
\title{Special characters}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
BACKSLASH

CARET

DOLLAR

DOT

PIPE

QUESTION

STAR

PLUS

OPEN_PAREN

CLOSE_PAREN

OPEN_BRACKET

OPEN_BRACE
}
\description{
Constants to match special characters
}
\examples{
BACKSLASH
CARET
DOLLAR
DOT
PIPE
QUESTION
STAR
PLUS
OPEN_PAREN
CLOSE_PAREN
OPEN_BRACKET
OPEN_BRACE

# Usage
x <- "\\\\^$."
rx <- BACKSLASH \%R\% CARET \%R\% DOLLAR \%R\% DOT
stringi::stri_detect_regex(x, rx)
# No escapes - these chars have special meaning inside regex
stringi::stri_detect_regex(x, x)
}
\references{
\url{http://www.regular-expressions.info/characters.html}
}
\seealso{
\code{\link{ALPHA}}, \code{\link{START}}, \code{\link{BOUNDARY}}
}
\keyword{datasets}

