% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSTM_TX.R
\name{CSTM_TX}
\alias{CSTM_TX}
\alias{dCSTM_TX}
\alias{pCSTM_TX}
\alias{rCSTM_TX}
\title{Custom Time- and Evidence-Dependent Drift Diffusion Model}
\usage{
dCSTM_TX(rt, resp, phi, x_res = "default", t_res = "default")

pCSTM_TX(rt, resp, phi, x_res = "default", t_res = "default")

rCSTM_TX(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in your specified order}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
Density (PDF), distribution function (CDF), and random sampler for a custom time- and evidence-dependent (CSTM_TX) drift diffusion model.
}
\references{
Murrow, M., & Holmes, W. R. (2023). PyBEAM: A Bayesian approach to parameter
inference for a wide class of binary evidence accumulation models.
\emph{Behavior Research Methods}, 1-21.
}
\author{
Raphael Hartmann & Matthew Murrow
}
