% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{source2}
\alias{source2}
\title{Read and Evaluate Code from an R Script}
\usage{
source2(file, local = FALSE)
}
\arguments{
\item{file}{usually a file name, see \code{\link[base]{parse}}}

\item{local}{specifies the environment where expressions
will be evaluated, see \code{\link[base]{source}}}
}
\value{
This function returns nothing.
}
\description{
A simplified alternative to \code{\link[base]{source}},
which additionally sets some environment variables whilst
executing a series of expressions to ease debugging.
}
\details{
The function sets/updates the following environment variables while
evaluating consecutive expressions:
\itemize{
   \item \code{__FILE__} -- path to current file,
   \item \code{__LINE__} -- line number where the currently executed
       expression begins,
   \item \code{__EXPR__} -- source code defining the expression.
}
}
\examples{
\donttest{
# example error handler - report source file and line number
old_option_error <- getOption("error")
options(error=function()
   cat(sprintf(
       "Error in \%s:\%s.\n", Sys.getenv("__FILE__"), Sys.getenv("__LINE__")
   ), file=stderr()))
# now call source2() to execute an R script that throws some errors...
options(error=old_option_error)  # cleanup
}

}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}
}
