% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read_fwf.R
\name{read_fwf}
\alias{fwf_empty}
\alias{fwf_positions}
\alias{fwf_widths}
\alias{read_fwf}
\title{Read a fixed width file.}
\usage{
read_fwf(file, col_positions, col_types = NULL, na = "NA", skip = 0,
  n_max = -1, progress = interactive())

fwf_empty(file, skip = 0, col_names = NULL)

fwf_widths(widths, col_names = NULL)

fwf_positions(start, end, col_names = NULL)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{col_positions}{Column positions, as created by \code{fwf_empty},
\code{fwf_widths} or \code{fwf_positions}. To read in only selected fields,
use \code{fwf_positions}.}

\item{col_types}{One of \code{NULL}, a list, a named list or a string.

  If \code{NULL}, the column type will be imputed from the first 30 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a list, it must contain one "\code{\link{collector}}" for each column.
  If you only want to read a subset of the columns, you can use a named list
  (where the names give the column names). If a column is not mentioned by
  name, it will not be included in the output.

  Alternatively, you can use a compact string representation where each
  character represents one column: c = character, d = double, i = integer,
  l = logical and \code{_} skips the column.}

\item{na}{String to use for missing values.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session. The display is updated every 50,000 values
and will only display if estimated reading time is 5 seconds or more.}

\item{col_names}{Either NULL, or a character vector column names.}

\item{widths}{Width of each field.}

\item{start,end}{Starting and ending (inclusive) positions of each field.}
}
\description{
A fixed width file can be a very compact representation of numeric data.
It's also very fast to parse, because every field is in the same place in
every line. Unfortunately, it's painful to parse because you need to
describe the length of every field. Readr aims to make it as easy as possible
by providing a number of different ways to describe the field structure.
}
\examples{
fwf_sample <- system.file("extdata/fwf-sample.txt", package = "readr")
cat(read_lines(fwf_sample))

# You can specify column positions in three ways:
# 1. Guess based on position of empty columns
read_fwf(fwf_sample, fwf_empty(fwf_sample))
# 2. A vector of field widths
read_fwf(fwf_sample, fwf_widths(c(2, 5, 3)))
# 3. Paired vectors of start and end positions
read_fwf(fwf_sample, fwf_positions(c(1, 4), c(2, 10)))
}
\seealso{
\code{\link{read_table}} to read fixed width files where each
  column is separated by whitespace.
}

