% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cpi.R
\name{read_cpi}
\alias{read_cpi}
\title{Download a tidy tibble containing the Consumer Price Index from the ABS}
\usage{
read_cpi(path = "data/ABS", show_progress_bars = TRUE,
  retain_files = FALSE)
}
\arguments{
\item{path}{character; default is "data/ABS". Only used if retain_files is set to
TRUE. Local directory in which to save downloaded ABS time series spreadsheets.}

\item{show_progress_bars}{logical; TRUE by default. If set to FALSE, progress
bars will not be shown when ABS spreadsheets are downloading.}

\item{retain_files}{logical; FALSE by default. When TRUE, the spreadsheets
downloaded from the ABS website will be saved in the directory specified with 'path'.}
}
\description{
\code{read_cpi()} uses the \code{read_abs()} function to download, import, and tidy
the Consumer Price Index from the ABS. It returns a tibble containing
two columns: the date and the CPI index value that corresponds to that date. This
makes joining the CPI to another dataframe easy. \code{read_cpi()}
returns the original (ie. not seasonally adjusted) all groups CPI for Australia.
If you want the analytical series (eg. seasonally adjusted CPI, or trimmed mean
CPI), you can use \code{read_abs()}.
}
\examples{

# Create a tibble called 'cpi' that contains the CPI index numbers for each quarter

\donttest{cpi <- read_cpi()}

# This tibble can now be joined to another to help streamline the process of
# deflating nominal values.

}
