% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_cwa.R
\name{convert_cwa}
\alias{convert_cwa}
\alias{read_cwa_csv}
\alias{read_cwa}
\title{Convert a CWA activity file to a CSV}
\usage{
convert_cwa(
  file,
  outfile = tempfile(fileext = ".csv"),
  xyz_only = TRUE,
  verbose = TRUE
)

read_cwa_csv(file, xyz_only = TRUE, verbose = TRUE)

read_cwa(
  file,
  outfile = tempfile(fileext = ".csv"),
  xyz_only = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file}{input CWA file}

\item{outfile}{output CSV file}

\item{xyz_only}{read only time and X/Y/Z columns}

\item{verbose}{print diagnostic messages}
}
\value{
Name of output CSV file
}
\description{
Convert a CWA activity file to a CSV
}
\examples{
gz_file = system.file("extdata", "ax3_testfile.cwa.gz", package = "read.cwa")
file = R.utils::gunzip(gz_file, temporary = TRUE, remove = FALSE, overwrite = TRUE)
out = read_cwa(file)
out = read_cwa(file, xyz_only = FALSE)
}
