% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBorders.R
\name{addBorders}
\alias{addBorders}
\title{add country and Bundesland borders to a map}
\usage{
addBorders(de = "grey80", eu = "black", add = TRUE, ...)
}
\arguments{
\item{de}{Color for Bundeslaender line (\code{\link{DEU}}). NA to suppress. DEFAULT: "grey80"}

\item{eu}{Color for countries line (\code{\link{EUR}}). NA to suppress. DEFAULT: "black"}

\item{add}{Logical: add to existing plot? DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link[raster:plot]{raster::plot()}}}
}
\value{
invisible list with DEU and EUR
}
\description{
add country and Bundesland borders to a map
}
\examples{
if(requireNamespace("raster", quietly=TRUE)){
plot(1, xlim=c(2,16), ylim=c(47,55))
addBorders()
plot(1, xlim=c(2,16), ylim=c(47,55))
addBorders(de="orange", eu=NA)
}

}
\seealso{
\code{\link{plotRadar}}, \code{\link{DEU}}, \code{\link{EUR}},
\href{https://bookdown.org/brry/rdwd/raster-data.html}{website raster chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2019
}
\keyword{aplot}
