% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVars.R
\name{readVars}
\alias{readVars}
\title{Process data from the DWD CDC FTP Server}
\usage{
readVars(file, progbar = TRUE)
}
\arguments{
\item{file}{Char (vector): name(s) of the file(s) downloaded with \code{\link{dataDWD}},
e.g. "~/DWDdata/tageswerte_KL_02575_akt.zip"}

\item{progbar}{Logical: present a progress bar with estimated remaining time?
If missing and length(file)==1, progbar is internally set to FALSE.
DEFAULT: TRUE}
}
\value{
Invisible data.frame of the desired dataset, or a list of data.frames
        if length(file) > 1.
}
\description{
Read climate variables (column meta data) from files downloaded with \code{\link{dataDWD}}.
The metadata file is read, processed and returned as a data.frame.\cr
\code{file} can be a vector with several filenames.
}
\examples{
\dontrun{ ## Excluded from CRAN checks
link <- selectDWD("Potsdam", res="daily", var="kl", per="recent")
file <- dataDWD(link, read=FALSE, dir=tempdir())
clim <- readDWD(file)
vars <- readVars(file)

}

}
\seealso{
\code{\link{dataDWD}}, \code{\link{readDWD}}, \code{\link{parameter_abbreviations}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2018
}
\keyword{file}
