% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.R
\name{get_net_relations_igraph}
\alias{get_net_relations_igraph}
\alias{summary.relations_igraph}
\alias{plot.relations_igraph}
\title{Retrieve an igraph relations network for a play}
\usage{
get_net_relations_igraph(play = play, corpus = corpus)

\method{summary}{relations_igraph}(object, ...)

\method{plot}{relations_igraph}(
  x,
  layout = igraph::layout_nicely,
  gender_colors = c(MALE = "#0073C2", FEMALE = "#EFC000", UNKNOWN = "#99979D"),
  show_others = c("vertex", "vertex_label", "none"),
  vertex_size = c(13, 4),
  vertex_label_size = c(0.8, 0.5),
  vertex_label_adjust = TRUE,
  vertex.label.color = "#03070f",
  vertex.label.family = "sans",
  vertex.label.font = 2L,
  vertex.frame.color = "white",
  edge.arrow.size = 0.25,
  edge.arrow.width = 1.5,
  edge.curved = 0.15,
  edge.label.family = "sans",
  edge.label.font = 4L,
  edge.label.cex = 0.75,
  ...
)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{object}{An object of class \code{relations_igraph}.}

\item{...}{Other arguments to be passed to \link[igraph]{plot.igraph}}

\item{x}{A \code{relations_igraph} object to plot.}

\item{layout}{Function, an algorithm used for graph layout. See
\link[igraph]{layout_}.}

\item{gender_colors}{Named vector with 3 values with colors for
MALE, FEMALE and UNKNOWN respectively. Set \code{NULL} to use default igraph
colors. If you set parameter \code{vertex.color} (see
\link[igraph]{igraph.plotting}), \code{gender_colors} will be ignored.}

\item{show_others}{Character value. What to do with vertices without
relations?
\itemize{
   \item \code{"vertex"}: plot only vertices without labels.
   \item \code{"vertex_label"}: plot both vertices and labels.
   \item \code{"none"}: do not plot vertices without relations.
}
The default is \code{"vertex"}.}

\item{vertex_size}{Numeric vector with two values. The first number is for
nodes with relations, the second number is for all other nodes.}

\item{vertex_label_size}{Numeric vector with two values. The first number
defines label sizes for nodes with relations, the second number for nodes
without relations.}

\item{vertex_label_adjust}{Logical value. If \code{TRUE}, labels positions
are moved to the top of the respective nodes. If \code{FALSE}, labels
are placed in the nodes centers. \code{TRUE} by default. If you set parameter
\code{vertex.label.dist}(see \link[igraph]{igraph.plotting}) by yourself,
\code{vertex_label_adjust} is ignored.}

\item{vertex.label.color}{See \link[igraph]{igraph.plotting}.}

\item{vertex.label.family}{See \link[igraph]{igraph.plotting}.}

\item{vertex.label.font}{See \link[igraph]{igraph.plotting}.}

\item{vertex.frame.color}{See \link[igraph]{igraph.plotting}.}

\item{edge.arrow.size}{See \link[igraph]{igraph.plotting}.}

\item{edge.arrow.width}{See \link[igraph]{igraph.plotting}.}

\item{edge.curved}{See \link[igraph]{igraph.plotting}.}

\item{edge.label.family}{See \link[igraph]{igraph.plotting}.}

\item{edge.label.font}{See \link[igraph]{igraph.plotting}.}

\item{edge.label.cex}{See \link[igraph]{igraph.plotting}.}
}
\value{
\code{relations_igraph} — an object that inherits \code{igraph} and
can be treated as such.
}
\description{
\code{get_net_relations_igraph()} a play network, given play and corpus names
. The network represent kinship and other relationships data, following the
encoding scheme proposed in
\insertCite{wiedmer_nathalie_2020_4621778}{rdracor}.
}
\section{Functions}{
\itemize{
\item \code{summary(relations_igraph)}: Meaningful summary for
\code{"relations_igraph"} object: relationships and their type.

\item \code{plot(relations_igraph)}: Plot \code{relations_igraph} using
\code{plot.igraph} with slightly modified defaults.

}}
\examples{
\donttest{
nedorosl_relations <- get_net_relations_igraph(
  play = "fonvizin-nedorosl",
  corpus = "rus"
)
plot(nedorosl_relations)
summary(nedorosl_relations)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{get_net_cooccur_igraph}}
}
