% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf_parse.R
\name{rdf_parse}
\alias{rdf_parse}
\title{Parse RDF Files}
\usage{
rdf_parse(doc, format = c("guess", "rdfxml", "nquads", "ntriples", "turtle",
  "jsonld"), rdf = NULL, base = getOption("rdflib_base_uri",
  "localhost://"), ...)
}
\arguments{
\item{doc}{path, URL, or literal string of the rdf document to parse}

\item{format}{rdf serialization format of the doc,
one of "rdfxml", "nquads", "ntriples", "turtle"
or "jsonld". If not provided, will try to guess based
on file extension and fall back on rdfxml.}

\item{rdf}{an existing rdf triplestore to extend with triples from
the parsed file.  Default will create a new rdf object.}

\item{base}{the base URI to assume for any relative URIs (blank nodes)}

\item{...}{additional parameters (not implemented)}
}
\value{
an rdf object, containing the redland world
and model objects
}
\description{
Parse RDF Files
}
\examples{
doc <- system.file("extdata", "dc.rdf", package="redland")
rdf <- rdf_parse(doc)

}
