% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_power.R
\name{rd_power}
\alias{rd_power}
\title{Power Analysis of Regression Discontinuity}
\usage{
rd_power(
  num.rep = 100,
  sample.size = 100,
  x.dist = "normal",
  x.para = c(0, 1),
  x.cut = 0,
  x.fuzzy = c(0, 0),
  x.design = NULL,
  coeff = c(0.3, 1, 0.2, 0.3),
  eta.sq = 0.5,
  alpha.list = c(0.001, 0.01, 0.05)
)
}
\arguments{
\item{num.rep}{Number of repetitions used to calculate the empirical alpha.}

\item{sample.size}{Number of observations in each sample.}

\item{x.dist}{Distribution of the assignment variable X.
\code{"normal"} distribution is the default. 
\code{"uniform"} distribution is the only other option.}

\item{x.para}{Parameters of the distribution of the assignment variable X.
If \code{x.dist} is \code{"normal"}, then \code{x.para} includes the
mean and sd of normal distribution.
If \code{x.dist} is \code{"uniform"}, then \code{x.para} includes the 
upper and lower boundaries of uniform distribution.}

\item{x.cut}{Cutpoint of RD with respect to the assignment variable X.}

\item{x.fuzzy}{Probabilities to be assigned to control for individuals in treatment 
based on cutoff, and to treatment for individuals in control based on cutoff.
For a sharp design, by default, the 1st entry is 0, and the 2nd entry is 0. 
For a fuzzy design, the 1st entry is the probability to be assigned to 
control for individuals above the cutpoint, and the 2nd entry is the 
probability to be assigned to treatment for individuals below the cutpoint.}

\item{x.design}{The treatment option according to design.
The entry is for X: \code{"g"} means treatment is assigned 
if X is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X is less than its cutoff, \code{"leq"} means treatment is assigned 
if X is less than or equal to its cutoff.}

\item{coeff}{Coefficients of variables in the linear model to generate data
The 1st entry is the intercept. 
The 2nd entry is the slope of treatment, i.e. treatment effect.
The 3rd entry is the slope of assignment.
The 4th entry is the slope of interaction between treatment and assignment.}

\item{eta.sq}{Expected partial eta-squared of the linear model with respect to the 
treatment itself. It is used to control the variance of noise in the linear model.}

\item{alpha.list}{List of significance levels used to calculate the empirical alpha.}
}
\value{
\code{rd_power} returns the results of 2 estimators as a table of \link{class} 
  "\code{rdp}", including mean, variance, and power of estimate. The function \code{summary}
  is used to obtain and print a summary of the power analysis.
  The 1st \code{Linear} results of the linear regression estimator 
  The 2nd \code{Opt} results of the local linear regression estimator
  of RD, with the optimal bandwidth in the IK 2012 paper.
}
\description{
\code{rd_power} computes the empirical probability that RD is significant,
i.e. the empirical alpha of null hypothesis: RD = 0
}
\examples{
\dontrun{
rd_power(x.design = "l")
rd_power(x.dist = "uniform", x.cut = 0.5, x.design = "l")
rd_power(x.fuzzy = c(0.1, 0.1), x.design = "l")
}
}
