% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_dois.R
\name{dc_dois}
\alias{dc_dois}
\title{DataCite REST API: dois}
\usage{
dc_dois(
  ids = NULL,
  query = NULL,
  created = NULL,
  registered = NULL,
  provider_id = NULL,
  client_id = NULL,
  person_id = NULL,
  resource_type_id = NULL,
  subject = NULL,
  schema_version = NULL,
  random = NULL,
  sample_size = NULL,
  sample_group = NULL,
  include = NULL,
  sort = NULL,
  limit = 25,
  page = 1,
  cursor = NULL,
  ...
)
}
\arguments{
\item{ids}{(character) one or more DOIs}

\item{query}{(character) Query string. See Querying below.}

\item{created}{(character) metadata where year of DOI creation is \code{created}.
See Filtering Responses below.}

\item{registered}{(character) metadata where year of DOI registration
is \code{year}. See Filtering Responses below.}

\item{provider_id}{(character) metadata associated with a specific DataCite
provider. See Filtering Responses below.}

\item{client_id}{(character) metadata associated with a specific DataCite
client. See Filtering Responses below.}

\item{person_id}{(character) metadata associated with a specific person's
ORCID iD. See Filtering Responses below.}

\item{resource_type_id}{(character) metadata for a specific
resourceTypeGeneral. See Filtering Responses below.}

\item{subject}{(character)}

\item{schema_version}{(character) metadata where schema version of the
deposited metadata is \code{schema-version}. See Filtering Responses below.}

\item{random}{(logical) return random set of results, can be combined
with any kind of query. default: \code{FALSE}.}

\item{sample_size}{(character)}

\item{sample_group}{(character)}

\item{include}{(character) vector of fields to return}

\item{sort}{(character) variable to sort by}

\item{limit}{(numeric/integer) results per page}

\item{page}{(numeric/integer) the page to get results for. default: 1}

\item{cursor}{(character) page cursor (used instead of \code{limit} param).
to use cursor pagination, set \code{cursor = 1}, then use the link in
\verb{$links$next}}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\description{
DataCite REST API: dois
}
\section{Querying}{

See https://support.datacite.org/docs/api-queries for details
}

\section{Filtering Responses}{

See
https://support.datacite.org/docs/api-queries#section-filtering-list-responses
for details
}

\examples{
\dontrun{
if (dc_check()) {
x <- dc_dois()
x
dc_dois(query = "birds")
dc_dois(query = "climate change")
dc_dois(query = "publicationYear:2016")
x <- dc_dois(query = "creators.familyName:mil*", verbose = TRUE)
lapply(x$data$attributes$creators, "[[", "familyName")
x <- dc_dois(query = "titles.title:climate +change")
lapply(x$data$attributes$titles, "[[", "title")
dc_dois(client_id = "dryad.dryad")
dc_dois(x$data$id[1])
dc_dois(x$data$id[1:3])
dc_dois("10.5281/zenodo.1308060")

# pagination
dc_dois(limit = 1)
x <- dc_dois(cursor = 1)
x$links$`next`
}}
}
