% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_journals.r
\name{cr_journals}
\alias{cr_journals}
\alias{cr_journals_}
\title{Search CrossRef journals}
\usage{
cr_journals(issn = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", flq = NULL, select = NULL, ...)

cr_journals_(issn = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", parse = FALSE, flq = NULL, select = NULL, ...)
}
\arguments{
\item{issn}{(character) One or more ISSN's. Format: XXXX-XXXX.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at. Minimum: 1. For
\code{\link{cr_works}}, and any function setting \code{works = TRUE},
the maximum offset value is 10000. For larger requests use \code{cursor}.}

\item{limit}{Number of results to return in the query. Not relavant when
searching with specific dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use
the sample parameter, the rows and offset parameters are ignored.
Ignored unless \code{works=TRUE}. Max: 100}

\item{sort}{Field to sort on. Acceptable set of fields to sort on: 
\itemize{
 \item \code{score} OR \code{relevance} - Sort by relevance score
 \item \code{updated} - Sort by date of most recent change to metadata. 
 Currently the same as deposited.
 \item \code{deposited} - Sort by time of most recent deposit
 \item \code{indexed} - Sort by time of most recent index
 \item \code{published} - Sort by publication date
 \item \code{published-print} - Sort by print publication date
 \item \code{published-online} - Sort by online publication date
 \item \code{issued} - Sort by issued date (earliest known publication date)
 \item \code{is-referenced-by-count} - Sort by number of times this DOI is 
 referenced by other Crossref DOIs
 \item \code{references-count} - Sort by number of references included in 
 the references section of the document identified by this DOI
}}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Boolean or string with
field to facet on. Valid fields are *, affiliation, funder-name,
funder-doi, orcid, container-title, assertion, archive, update-type,
issn, published, source, type-name, publisher-name, license,
category-name, assertion-group. Default: \code{FALSE}}

\item{works}{(logical) If \code{TRUE}, works returned as well, if not then not.}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used. 
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{flq}{field queries. One or more field queries. Acceptable set of 
field query parameters are: 
\itemize{
 \item \code{query.title} - Query title and subtitle
 \item \code{query.container-title}    - Query container-title aka. publication name
 \item \code{query.author} - Query author first and given names
 \item \code{query.editor} - Query editor first and given names
 \item \code{query.chair}    - Query chair first and given names
 \item \code{query.translator} - Query translator first and given names
 \item \code{query.contributor} - Query author, editor, chair and translator 
 first and given names
 \item \code{query.bibliographic} - Query bibliographic information, useful for 
 citation lookup. Includes titles, authors, ISSNs and publication years
 \item \code{query.affiliation} - Query contributor affiliations
}}

\item{select}{(character) One or more field to return (only those fields 
are returned)}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search CrossRef journals
}
\details{
BEWARE: The API will only work for CrossRef DOIs.

Note that some parameters are ignored unless \code{works=TRUE}: sample, sort,
order, filter
}
\section{Explanation of some data fields}{

\itemize{
\item backfile_dois: Back file records have a publication date older than
two years ago.
\item current_dois: Current records are anything published in the last
two years.
}
}

\examples{
\dontrun{
cr_journals(issn="2167-8359")
cr_journals()
cr_journals(issn="2167-8359", works=TRUE)
cr_journals(issn=c('1803-2427','2326-4225'))
cr_journals(query="ecology")
cr_journals(issn="2167-8359", query='ecology', works=TRUE,
   sort='score', order="asc")
cr_journals(issn="2167-8359", query='ecology', works=TRUE, sort='score',
   order="desc")
cr_journals(issn="2167-8359", works=TRUE,
   filter=c(from_pub_date='2014-03-03'))
cr_journals(query="peerj")
cr_journals(issn='1803-2427', works=TRUE)
cr_journals(issn='1803-2427', works=TRUE, sample=1)
cr_journals(limit=2)

## get facets back
cr_journals('1803-2427', works=TRUE, facet=TRUE)
cr_journals('1803-2427', works=TRUE, facet="published:*", limit = 0)
cr_journals(issn=c('1803-2427','2326-4225'), works=TRUE,
  facet="published:*", limit = 10)

# Use the cursor for deep paging
cr_journals(issn='1932-6203', works = TRUE, cursor = "*", cursor_max = 500,
   limit = 100)
cr_journals(c('1932-6203', '0028-0836'), works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)

# fails, if you want works, you must give an ISSN
# cr_journals(query = "ecology", filter=c(has_full_text = TRUE),
#    works = TRUE)

# Low level function - does no parsing to data.frame, get json or a list
cr_journals_(query = 'ecology')
cr_journals_("2167-8359")
cr_journals_(query = 'ecology', parse=TRUE)
cr_journals_("2167-8359", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
cr_journals_("2167-8359", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100, parse = TRUE)

# field queries
## query.author
cr_journals("2167-8359", works = TRUE, flq = c(`query.author` = 'Jane'))

# select only certain fields to return
res <- cr_journals('2167-8359', works = TRUE, 
  select = c('DOI', 'title'))
names(res$data)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}
