% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_map.R
\name{kde_map}
\alias{kde_map}
\title{Kernel Density Estimation and Heat Map Generation for Crime Incidents}
\usage{
kde_map(data, pts = NULL)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{pts}{Either true or false. Dictates whether the incident points will
be plotted on the map widget. If \code{NULL}, the default value is \code{TRUE}.}
}
\value{
A \pkg{Leaflet} map with three layers: an 'ESRI' base-map, all crime
    incidents plotted (with incident info pop-up windows), and a kernel
    density estimate of those points.
}
\description{
This function computes a kernel density estimate of crime
    incident locations and returns a 'Leaflet' map of the incidents. The data
    is based on the Chicago Police Department RMS structure and populates
    pop-up windows with the incident location for each incident.
}
\examples{
#Using provided dataset from Chicago Data Portal:
data(crimes)
crimes <- head(crimes, 1000)
library('leaflet') # needed to install basemap providers
kde_map(crimes)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{dynamic}
\keyword{hplot}
\keyword{methods}
\keyword{spatial}
