% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiVDA.r
\name{multiVDA}
\alias{multiVDA}
\title{Pairwise Vargha and Delaney's A and Cliff's delta}
\usage{
multiVDA(formula = NULL, data = NULL, x = NULL, g = NULL,
  statistic = "VDA", digits = 3, ...)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable.}

\item{g}{If no formula is given, the grouping variable.}

\item{statistic}{One of \code{"VDA"}, \code{"CD"}, or \code{"r"}.
This determines which statistic will be
evaluated to determine the comparison with the
most divergent groups.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcox.test} function.}
}
\value{
A list containing a data frame of pairwise statistics,
        and the comparison with the most extreme value
        of the chosen statistic.
}
\description{
Calculates Vargha and Delaney's A (VDA),
             Cliff's delta (CD), and r
             for several groups in a pairwise manner.
}
\details{
VDA and CD are effect size statistic appropriate
         in cases where a Wilcoxon-Mann-Whitney test might be used.
         Here, the pairwise approach would be used in cases where
         a Kruskal-Wallis test might be used.
         VDA ranges from 0 to 1, 
         with 0.5 indicating stochastic equality,
         and 1 indicating that the first group dominates the second.
         CD ranges from -1 to 1, with 0 indicating stochastic equality,
         and 1 indicating that the first group dominates the second.
         r ranges from approximately, -0.86 to 0.86, 
         depending on sample size,
         with 0 indicating no effect,
         and a positive result indicating
         that values in the first group are greater than in the second.
         
         In the function output,
         \code{VDA.m} is the greater of VDA or 1-VDA.
         \code{CD.m} is the absolute value of CD.
         \code{r.m} is the absolute value of r.
         
         The function calculates VDA and Cliff's delta from the "W" 
         U statistic from the
         \code{wilcox.test} function.
         Specifically, \code{VDA = U/(n1*n2); CD = (VDA-0.5)*2}.
         For r, the Z value is extracted 
         from the \code{wilcox_test} function in the
          coin package.  r  is calculated as Z divided by 
          square root of the total observations.
           
         The input should include either \code{formula} and \code{data};
         or \code{var}, and \code{group}.
         
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          When the data in the first group are greater than
          in the second group, 
          VDA is > 0.5, CD is positive, and r is positive.
          When the data in the second group are greater than
          in the first group, 
          VDA is < 0.5, CD is negative, and r is negative.
          Be cautious with this interpretation, as R will alphabetize
          groups in the formula interface if the grouping variable
          is not already a factor.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(PoohPiglet)
multiVDA(Likert ~ Speaker, data=PoohPiglet)

}
\references{
\url{http://rcompanion.org/handbook/F_08.html}
}
\seealso{
\code{\link{cliffDelta}}, \code{\link{cliffDelta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
