% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseGeometric.r
\name{groupwiseGeometric}
\alias{groupwiseGeometric}
\title{Groupwise geometric means and confidence intervals}
\usage{
groupwiseGeometric(data, group, var, conf = 0.95, na.rm = TRUE,
  digits = 3, ...)
}
\arguments{
\item{data}{The data frame to use.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{conf}{The confidence interval to use.}

\item{na.rm}{If \code{TRUE}, removes NA values in the measurement variable.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments.  Not currently useful.}
}
\value{
A data frame of geometric means, standard deviations, standard 
        errors, and confidence intervals.
}
\description{
Calculates geometric means and confidence intervals for
             groups.
}
\details{
The function computes means, standard deviations, standard errors, 
         and confidence intervals on log-transformed values. Confidence
         intervals are calculated in the traditional
         manner with the t-distribution.  These statistics assume that
         the data are log-normally distributed. For data not meeting this
         assumption, medians and confidence intervals by bootstrap may be more 
         appropriate.
}
\examples{
data(Catbus)
groupwiseGeometric(data   = Catbus,
                   var    = "Steps",
                   group  = c("Sex", "Teacher"))
                      
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/C_03.html}
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseMedian}}
         \code{\link{groupwiseHuber}}
}
\concept{
geometric mean confidence interval standard deviation error
}

