% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nagelkerke.r
\name{nagelkerke}
\alias{nagelkerke}
\title{Pseudo r-squared measures for various models}
\usage{
nagelkerke(fit, null = NULL)
}
\arguments{
\item{fit}{The fitted model object for which to determine pseudo r-squared.}

\item{null}{The null model object against which to compare the fitted model 
object. The null model must be nested in the fitted model to be 
valid. This is optional for some model objects
and required for others.}
}
\value{
A list of four objects describing the models used, the pseudo 
        r-squared values, the likelihood ratio test for the model, and any
        warning messages.
}
\description{
Produces McFadden, Cox and Snell, and Nagelkerke pseudo 
             R-squared measures, along with p-values, for models.
}
\details{
Pseudo R-squared values are not directly comparable to the  
          R-squared for OLS models.  Nor can they be interpreted as the  
          proportion of the variability in the dependent variable that is  
          explained by model. Instead pseudo R-squared measures are relative
          measures among similar models indicating how well the model
          explains the data.
          
          Cox and Snell is also referred to as ML. Nagelkerke is also  
          referred to as Cragg and Uhler.
          
          Model objects accepted are lm, glm, gls, lme, lmer, lmerTest, nls,      
          clm, clmm, vglm, glmer, negbin, zeroinfl.            
                                      
          Model objects that require the null model to 
          be defined are nls, lmer, glmer and clmm. 
          Other objects use the \code{update} function to
          define the null model.
          
          Likelihoods are found using ML (\code{REML = FALSE}).
}
\examples{
### Logistic regression example
data(AndersonBias)
model = glm(Result ~ County + Sex + County:Sex,
           weight = Count,
           data = AndersonBias,
           family = binomial(link="logit"))
nagelkerke(model)

### Quadratic plateau example 
### With nls, the  null needs to be defined
data(BrendonSmall)
quadplat = function(x, a, b, clx) {
          ifelse(x  < clx, a + b * x   + (-0.5*b/clx) * x   * x,
                           a + b * clx + (-0.5*b/clx) * clx * clx)}
model = nls(Sodium ~ quadplat(Calories, a, b, clx),
            data = BrendonSmall,
            start = list(a   = 519,
                         b   = 0.359,
                         clx = 2304))
nullfunct = function(x, m){m}
null.model = nls(Sodium ~ nullfunct(Calories, m),
             data = BrendonSmall,
             start = list(m   = 1346))
nagelkerke(model, null=null.model)

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/G_10.html}
}
\seealso{
\code{\link{nagelkerkeHermite}}
}
\concept{
pseudo r-squared cox snell nagelkerke likelihood
}

