% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-histcount.R, R/cdo-histfreq.R,
%   R/cdo-histmean.R, R/cdo-histsum.R, R/family-histogram.R
\name{cdo_histcount}
\alias{cdo_histcount}
\alias{cdo_histfreq}
\alias{cdo_histmean}
\alias{cdo_histsum}
\alias{histogram}
\title{Histogram}
\usage{
cdo_histcount(ifile, bounds = NULL, ofile = NULL)

cdo_histfreq(ifile, bounds = NULL, ofile = NULL)

cdo_histmean(ifile, bounds = NULL, ofile = NULL)

cdo_histsum(ifile, bounds = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{bounds}{FLOAT - Comma-separated list of the bin bounds (-inf and inf valid)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module creates bins for a histogram of the input data. The bins have to be adjacent and have non-overlapping intervals. The user has to define the bounds of the bins. The first value is the lower bound and the second value the upper bound of the first bin. The bounds of the second bin are defined by the second and third value, aso. Only 2-dimensional input fields are allowed. The output file contains one vertical level for each of the bins requested.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{histcount  Histogram count
           Number of elements in the bin range.
histsum    Histogram sum
           Sum of elements in the bin range.
histmean   Histogram mean
           Mean of elements in the bin range.
histfreq   Histogram frequency
           Relative frequency of elements in the bin range.
}\if{html}{\out{</div>}}
}
