/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CarbonylEliminationReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CarbonylEliminationReaction.class);

    @Override
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#CarbonylElimination", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: CarbonylEliminationReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("CarbonylEliminationReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("CarbonylEliminationReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(1024) || !atomi.getSymbol().equals("O") || atomi.getFormalCharge() != 1) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (!bondi.getFlag(1024) || bondi.getOrder() != IBond.Order.TRIPLE || !(atomj = bondi.getOther(atomi)).getFlag(1024)) continue;
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || !bondj.getFlag(1024) || bondj.getOrder() != IBond.Order.SINGLE || !(atomk = bondj.getOther(atomj)).getFlag(1024) || atomk.getFormalCharge() != 0) continue;
                    ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                    atomList.add(atomk);
                    atomList.add(atomj);
                    ArrayList<IBond> bondList = new ArrayList<IBond>();
                    bondList.add(bondj);
                    IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    moleculeSet.addAtomContainer(reactant);
                    IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                    if (reaction == null) continue;
                    setOfReactions.addReaction(reaction);
                }
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getSymbol().equals("O") || atomi.getFormalCharge() != 1) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                if (bondi.getOrder() != IBond.Order.TRIPLE) continue;
                IAtom atomj = bondi.getOther(atomi);
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || bondj.getOrder() != IBond.Order.SINGLE || (atomk = bondj.getOther(atomj)).getFormalCharge() != 0) continue;
                    atomi.setFlag(1024, true);
                    bondi.setFlag(1024, true);
                    atomj.setFlag(1024, true);
                    bondj.setFlag(1024, true);
                    atomk.setFlag(1024, true);
                }
            }
        }
    }
}

