/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.DfPattern;

public final class Expr {
    public static final int UNKNOWN_STEREO = -1;
    private Type type;
    private int value;
    private Expr left;
    private Expr right;
    private IAtomContainer query;
    private DfPattern ptrn;
    private static LoadingCache<IAtomContainer, int[]> cacheRCounts;

    public Expr() {
        this(Type.TRUE);
    }

    public Expr(Type op) {
        this.setPrimitive(op);
    }

    public Expr(Type op, int val) {
        this.setPrimitive(op, val);
    }

    public Expr(Type op, Expr left, Expr right) {
        this.setLogical(op, left, right);
    }

    public Expr(Type op, IAtomContainer mol) {
        this.setRecursive(op, mol);
    }

    public Expr(Expr expr) {
        this.set(expr);
    }

    private static boolean eq(Integer a, int b) {
        return a != null && a == b;
    }

    private static int unbox(Integer x) {
        return x != null ? x : 0;
    }

    private static boolean isInRingSize(IAtom atom, IBond prev, IAtom beg, int size, int req) {
        atom.setFlag(16, true);
        for (IBond bond : atom.bonds()) {
            if (bond == prev) continue;
            IAtom nbr = bond.getOther(atom);
            if (nbr.equals(beg)) {
                return size == req;
            }
            if (size >= req || nbr.getFlag(16) || !Expr.isInRingSize(nbr, bond, beg, size + 1, req)) continue;
            return true;
        }
        atom.setFlag(16, false);
        return false;
    }

    private static boolean isInRingSize(IAtom atom, int size) {
        for (IAtom a : atom.getContainer().atoms()) {
            a.setFlag(16, false);
        }
        return Expr.isInRingSize(atom, null, atom, 1, size);
    }

    private static boolean isInSmallRingSize(IAtom atom, int size) {
        IAtomContainer mol = atom.getContainer();
        int[] distTo = new int[mol.getAtomCount()];
        Arrays.fill(distTo, 1 + distTo.length);
        distTo[atom.getIndex()] = 0;
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        queue.push(atom);
        int smallest = 1 + distTo.length;
        while (!queue.isEmpty()) {
            IAtom a = (IAtom)queue.poll();
            int dist = 1 + distTo[a.getIndex()];
            for (IBond b : a.bonds()) {
                int tmp;
                IAtom nbr = b.getOther(a);
                if (dist < distTo[nbr.getIndex()]) {
                    distTo[nbr.getIndex()] = dist;
                    queue.add(nbr);
                    continue;
                }
                if (dist == 2 + distTo[nbr.getIndex()] || (tmp = dist + distTo[nbr.getIndex()]) >= smallest) continue;
                smallest = tmp;
            }
            if (2 * dist <= 1 + size) continue;
            break;
        }
        return smallest == size;
    }

    private boolean matches(Type type, IAtom atom, int stereo) {
        switch (type) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case IS_AROMATIC: {
                return atom.isAromatic();
            }
            case IS_ALIPHATIC: {
                return !atom.isAromatic();
            }
            case IS_IN_RING: {
                return atom.isInRing();
            }
            case IS_IN_CHAIN: {
                return !atom.isInRing();
            }
            case IS_HETERO: {
                return !Expr.eq(atom.getAtomicNumber(), 6) && !Expr.eq(atom.getAtomicNumber(), 1);
            }
            case HAS_IMPLICIT_HYDROGEN: {
                return atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() > 0;
            }
            case HAS_ISOTOPE: {
                return atom.getMassNumber() != null;
            }
            case HAS_UNSPEC_ISOTOPE: {
                return atom.getMassNumber() == null;
            }
            case UNSATURATED: {
                for (IBond bond : atom.bonds()) {
                    if (bond.getOrder() != IBond.Order.DOUBLE) continue;
                    return true;
                }
                return false;
            }
            case ELEMENT: {
                return Expr.eq(atom.getAtomicNumber(), this.value);
            }
            case ALIPHATIC_ELEMENT: {
                return !atom.isAromatic() && Expr.eq(atom.getAtomicNumber(), this.value);
            }
            case AROMATIC_ELEMENT: {
                return atom.isAromatic() && Expr.eq(atom.getAtomicNumber(), this.value);
            }
            case IMPL_H_COUNT: {
                return Expr.eq(atom.getImplicitHydrogenCount(), this.value);
            }
            case TOTAL_H_COUNT: {
                if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() > this.value) {
                    return false;
                }
                return Expr.getTotalHCount(atom) == this.value;
            }
            case DEGREE: {
                return atom.getBondCount() == this.value;
            }
            case HEAVY_DEGREE: {
                return atom.getBondCount() - (Expr.getTotalHCount(atom) - atom.getImplicitHydrogenCount()) == this.value;
            }
            case TOTAL_DEGREE: {
                int x = atom.getBondCount() + Expr.unbox(atom.getImplicitHydrogenCount());
                return x == this.value;
            }
            case VALENCE: {
                int v = Expr.unbox(atom.getImplicitHydrogenCount());
                if (v > this.value) {
                    return false;
                }
                for (IBond bond : atom.bonds()) {
                    if (bond.getOrder() == null) continue;
                    v += bond.getOrder().numeric().intValue();
                }
                return v == this.value;
            }
            case ISOTOPE: {
                return Expr.eq(atom.getMassNumber(), this.value);
            }
            case FORMAL_CHARGE: {
                return Expr.eq(atom.getFormalCharge(), this.value);
            }
            case RING_BOND_COUNT: {
                if (!atom.isInRing() || atom.getBondCount() < this.value) {
                    return false;
                }
                int rbonds = 0;
                for (IBond bond : atom.bonds()) {
                    rbonds += bond.isInRing() ? 1 : 0;
                }
                return rbonds == this.value;
            }
            case RING_COUNT: {
                return atom.isInRing() && Expr.getRingCount(atom) == this.value;
            }
            case RING_SMALLEST: {
                return atom.isInRing() && Expr.isInSmallRingSize(atom, this.value);
            }
            case RING_SIZE: {
                return atom.isInRing() && Expr.isInRingSize(atom, this.value);
            }
            case HETERO_SUBSTITUENT_COUNT: {
                if (atom.getBondCount() < this.value) {
                    return false;
                }
                int q = 0;
                for (IBond bond : atom.bonds()) {
                    q += this.matches(Type.IS_HETERO, bond.getOther(atom), stereo) ? 1 : 0;
                }
                return q == this.value;
            }
            case INSATURATION: {
                int db = 0;
                for (IBond bond : atom.bonds()) {
                    if (bond.getOrder() != IBond.Order.DOUBLE) continue;
                    ++db;
                }
                return db == this.value;
            }
            case HYBRIDISATION_NUMBER: {
                IAtomType.Hybridization hyb = atom.getHybridization();
                if (hyb == null) {
                    return false;
                }
                switch (this.value) {
                    case 1: {
                        return hyb == IAtomType.Hybridization.SP1;
                    }
                    case 2: {
                        return hyb == IAtomType.Hybridization.SP2;
                    }
                    case 3: {
                        return hyb == IAtomType.Hybridization.SP3;
                    }
                    case 4: {
                        return hyb == IAtomType.Hybridization.SP3D1;
                    }
                    case 5: {
                        return hyb == IAtomType.Hybridization.SP3D2;
                    }
                    case 6: {
                        return hyb == IAtomType.Hybridization.SP3D3;
                    }
                    case 7: {
                        return hyb == IAtomType.Hybridization.SP3D4;
                    }
                    case 8: {
                        return hyb == IAtomType.Hybridization.SP3D5;
                    }
                }
                return false;
            }
            case PERIODIC_GROUP: {
                return atom.getAtomicNumber() != null && Elements.ofNumber(atom.getAtomicNumber()).group() == this.value;
            }
            case STEREOCHEMISTRY: {
                return stereo == -1 || stereo == this.value;
            }
            case REACTION_ROLE: {
                ReactionRole role = (ReactionRole)((Object)atom.getProperty("cdk:ReactionRole"));
                return role != null && role.ordinal() == this.value;
            }
            case AND: {
                return this.left.matches(this.left.type, atom, stereo) && this.right.matches(this.right.type, atom, stereo);
            }
            case OR: {
                return this.left.matches(this.left.type, atom, stereo) || this.right.matches(this.right.type, atom, stereo);
            }
            case NOT: {
                return !this.left.matches(this.left.type, atom, stereo) || stereo == -1 && (this.left.type == Type.STEREOCHEMISTRY || this.left.type == Type.OR && this.left.left.type == Type.STEREOCHEMISTRY);
            }
            case RECURSIVE: {
                if (this.ptrn == null) {
                    this.ptrn = DfPattern.findSubstructure(this.query);
                }
                return this.ptrn.matchesRoot(atom);
            }
        }
        throw new IllegalArgumentException("Cannot match AtomExpr, type=" + (Object)((Object)type));
    }

    public boolean matches(IBond bond, int stereo) {
        switch (this.type) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case ALIPHATIC_ORDER: {
                return !bond.isAromatic() && bond.getOrder() != null && bond.getOrder().numeric() == this.value;
            }
            case ORDER: {
                return bond.getOrder() != null && bond.getOrder().numeric() == this.value;
            }
            case IS_AROMATIC: {
                return bond.isAromatic();
            }
            case IS_ALIPHATIC: {
                return !bond.isAromatic();
            }
            case IS_IN_RING: {
                return bond.isInRing();
            }
            case IS_IN_CHAIN: {
                return !bond.isInRing();
            }
            case SINGLE_OR_AROMATIC: {
                return bond.isAromatic() || IBond.Order.SINGLE.equals((Object)bond.getOrder());
            }
            case DOUBLE_OR_AROMATIC: {
                return bond.isAromatic() || IBond.Order.DOUBLE.equals((Object)bond.getOrder());
            }
            case SINGLE_OR_DOUBLE: {
                return IBond.Order.SINGLE.equals((Object)bond.getOrder()) || IBond.Order.DOUBLE.equals((Object)bond.getOrder());
            }
            case STEREOCHEMISTRY: {
                return stereo == -1 || this.value == stereo;
            }
            case AND: {
                return this.left.matches(bond, stereo) && this.right.matches(bond, stereo);
            }
            case OR: {
                return this.left.matches(bond, stereo) || this.right.matches(bond, stereo);
            }
            case NOT: {
                return !this.left.matches(bond, stereo) || stereo == -1 && (this.left.type == Type.STEREOCHEMISTRY || this.left.type == Type.OR && this.left.left.type == Type.STEREOCHEMISTRY);
            }
        }
        throw new IllegalArgumentException("Cannot match BondExpr, type=" + (Object)((Object)this.type));
    }

    public boolean matches(IBond bond) {
        return this.matches(bond, -1);
    }

    private static int getTotalHCount(IAtom atom) {
        int h = Expr.unbox(atom.getImplicitHydrogenCount());
        for (IBond bond : atom.bonds()) {
            if (!Expr.eq(bond.getOther(atom).getAtomicNumber(), 1)) continue;
            ++h;
        }
        return h;
    }

    public boolean matches(IAtom atom) {
        return atom != null && this.matches(this.type, atom, -1);
    }

    public boolean matches(IAtom atom, int stereo) {
        return atom != null && this.matches(this.type, atom, stereo);
    }

    public Expr and(Expr expr) {
        if (this.type == Type.TRUE) {
            this.set(expr);
        } else if (expr.type != Type.TRUE) {
            if (this.type.isLogical() && !expr.type.isLogical()) {
                if (this.type == Type.AND) {
                    this.right.and(expr);
                } else if (this.type != Type.NOT) {
                    this.setLogical(Type.AND, expr, new Expr(this));
                } else {
                    this.setLogical(Type.AND, expr, new Expr(this));
                }
            } else {
                this.setLogical(Type.AND, new Expr(this), expr);
            }
        }
        return this;
    }

    public Expr or(Expr expr) {
        if (this.type == Type.TRUE || this.type == Type.FALSE || this.type == Type.NONE) {
            this.set(expr);
        } else if (expr.type != Type.TRUE && expr.type != Type.FALSE && expr.type != Type.NONE) {
            if (this.type.isLogical() && !expr.type.isLogical()) {
                if (this.type == Type.OR) {
                    this.right.or(expr);
                } else if (this.type != Type.NOT) {
                    this.setLogical(Type.OR, expr, new Expr(this));
                } else {
                    this.setLogical(Type.OR, new Expr(this), expr);
                }
            } else {
                this.setLogical(Type.OR, new Expr(this), expr);
            }
        }
        return this;
    }

    public Expr negate() {
        switch (this.type) {
            case TRUE: {
                this.type = Type.FALSE;
                break;
            }
            case FALSE: {
                this.type = Type.TRUE;
                break;
            }
            case HAS_ISOTOPE: {
                this.type = Type.HAS_UNSPEC_ISOTOPE;
                break;
            }
            case HAS_UNSPEC_ISOTOPE: {
                this.type = Type.HAS_ISOTOPE;
                break;
            }
            case IS_AROMATIC: {
                this.type = Type.IS_ALIPHATIC;
                break;
            }
            case IS_ALIPHATIC: {
                this.type = Type.IS_AROMATIC;
                break;
            }
            case IS_IN_RING: {
                this.type = Type.IS_IN_CHAIN;
                break;
            }
            case IS_IN_CHAIN: {
                this.type = Type.IS_IN_RING;
                break;
            }
            case NOT: {
                this.set(this.left);
                break;
            }
            default: {
                this.setLogical(Type.NOT, new Expr(this), null);
            }
        }
        return this;
    }

    public void setPrimitive(Type type, int val) {
        if (!type.hasValue()) {
            throw new IllegalArgumentException("Value provided for non-value expression type!");
        }
        this.type = type;
        this.value = val;
        this.left = null;
        this.right = null;
        this.query = null;
    }

    public void setPrimitive(Type type) {
        if (type.hasValue() || type.isLogical()) {
            throw new IllegalArgumentException("Expression type requires a value!");
        }
        this.type = type;
        this.value = -1;
        this.left = null;
        this.right = null;
        this.query = null;
    }

    public void setLogical(Type type, Expr left, Expr right) {
        switch (type) {
            case AND: 
            case OR: {
                this.type = type;
                this.value = 0;
                this.left = left;
                this.right = right;
                this.query = null;
                break;
            }
            case NOT: {
                this.type = type;
                if (left != null && right == null) {
                    this.left = left;
                } else if (left == null && right != null) {
                    this.left = right;
                } else if (left != null) {
                    throw new IllegalArgumentException("Only one sub-expression should be provided for NOT expressions!");
                }
                this.query = null;
                this.value = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Left/Right sub expressions supplied for  non-logical operator!");
            }
        }
    }

    private void setRecursive(Type type, IAtomContainer mol) {
        switch (type) {
            case RECURSIVE: {
                this.type = type;
                this.value = 0;
                this.left = null;
                this.right = null;
                this.query = mol;
                this.ptrn = null;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void set(Expr expr) {
        this.type = expr.type;
        this.value = expr.value;
        this.left = expr.left;
        this.right = expr.right;
        this.query = expr.query;
    }

    public Type type() {
        return this.type;
    }

    public int value() {
        return this.value;
    }

    public Expr left() {
        return this.left;
    }

    public Expr right() {
        return this.right;
    }

    public IAtomContainer subquery() {
        return this.query;
    }

    private static int[] getRingCounts(IAtomContainer mol) {
        int[] rcounts = new int[mol.getAtomCount()];
        for (int[] path : Cycles.mcb(mol).paths()) {
            for (int i = 1; i < path.length; ++i) {
                int n = path[i];
                rcounts[n] = rcounts[n] + 1;
            }
        }
        return rcounts;
    }

    private static int getRingCount(IAtom atom) {
        IAtomContainer mol = atom.getContainer();
        if (cacheRCounts == null) {
            cacheRCounts = CacheBuilder.newBuilder().maximumWeight(1000L).weigher(new Weigher<IAtomContainer, int[]>(){

                @Override
                public int weigh(IAtomContainer key, int[] value) {
                    return value.length;
                }
            }).build(new CacheLoader<IAtomContainer, int[]>(){

                @Override
                public int[] load(IAtomContainer key) throws Exception {
                    return Expr.getRingCounts(key);
                }
            });
        }
        return cacheRCounts.getUnchecked(mol)[atom.getIndex()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expr atomExpr = (Expr)o;
        return this.type == atomExpr.type && this.value == atomExpr.value && Objects.equals(this.left, atomExpr.left) && Objects.equals(this.right, atomExpr.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value, this.left, this.right});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        if (this.type.isLogical()) {
            switch (this.type) {
                case NOT: {
                    sb.append('(').append(this.left).append(')');
                    break;
                }
                case AND: 
                case OR: {
                    sb.append('(').append(this.left).append(',').append(this.right).append(')');
                }
            }
        } else if (this.type.hasValue()) {
            sb.append('=').append(this.value);
        } else if (this.type == Type.RECURSIVE) {
            sb.append("(...)");
        }
        return sb.toString();
    }

    public static enum Type {
        TRUE,
        FALSE,
        IS_AROMATIC,
        IS_ALIPHATIC,
        IS_IN_RING,
        IS_IN_CHAIN,
        IS_HETERO,
        IS_ALIPHATIC_HETERO,
        HAS_IMPLICIT_HYDROGEN,
        HAS_ISOTOPE,
        HAS_UNSPEC_ISOTOPE,
        HAS_HETERO_SUBSTITUENT,
        HAS_ALIPHATIC_HETERO_SUBSTITUENT,
        UNSATURATED,
        SINGLE_OR_DOUBLE,
        SINGLE_OR_AROMATIC,
        DOUBLE_OR_AROMATIC,
        ELEMENT,
        ALIPHATIC_ELEMENT,
        AROMATIC_ELEMENT,
        IMPL_H_COUNT,
        TOTAL_H_COUNT,
        DEGREE,
        TOTAL_DEGREE,
        HEAVY_DEGREE,
        VALENCE,
        ISOTOPE,
        FORMAL_CHARGE,
        RING_BOND_COUNT,
        RING_COUNT,
        RING_SMALLEST,
        RING_SIZE,
        HYBRIDISATION_NUMBER,
        HETERO_SUBSTITUENT_COUNT,
        ALIPHATIC_HETERO_SUBSTITUENT_COUNT,
        PERIODIC_GROUP,
        INSATURATION,
        REACTION_ROLE,
        STEREOCHEMISTRY,
        ALIPHATIC_ORDER,
        ORDER,
        AND,
        OR,
        NOT,
        RECURSIVE,
        NONE;


        boolean isLogical() {
            switch (this) {
                case AND: 
                case OR: 
                case NOT: {
                    return true;
                }
            }
            return false;
        }

        boolean hasValue() {
            switch (this) {
                case TRUE: 
                case FALSE: 
                case IS_AROMATIC: 
                case IS_ALIPHATIC: 
                case IS_IN_RING: 
                case IS_IN_CHAIN: 
                case IS_HETERO: 
                case HAS_IMPLICIT_HYDROGEN: 
                case HAS_ISOTOPE: 
                case HAS_UNSPEC_ISOTOPE: 
                case UNSATURATED: 
                case AND: 
                case OR: 
                case NOT: 
                case RECURSIVE: 
                case SINGLE_OR_AROMATIC: 
                case DOUBLE_OR_AROMATIC: 
                case SINGLE_OR_DOUBLE: 
                case NONE: 
                case IS_ALIPHATIC_HETERO: 
                case HAS_ALIPHATIC_HETERO_SUBSTITUENT: 
                case HAS_HETERO_SUBSTITUENT: {
                    return false;
                }
            }
            return true;
        }
    }
}

