/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.isotopes.IsotopeReader;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;

public class XMLIsotopeFactory
extends IsotopeFactory {
    private static XMLIsotopeFactory ifac = null;
    private boolean debug = false;

    private XMLIsotopeFactory(IChemObjectBuilder builder) throws IOException {
        InputStream ins;
        logger.info("Creating new IsotopeFactory");
        String errorMessage = "There was a problem getting org.openscience.cdk.config.isotopes.xml as a stream";
        try {
            String configFile = "org/openscience/cdk/config/data/isotopes.xml";
            if (this.debug) {
                logger.debug("Getting stream for ", configFile);
            }
            ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        }
        catch (Exception exception) {
            logger.error(errorMessage);
            logger.debug(exception);
            throw new IOException(errorMessage);
        }
        if (ins == null) {
            logger.error(errorMessage);
            throw new IOException(errorMessage);
        }
        IsotopeReader reader = new IsotopeReader(ins, builder);
        List<IIsotope> isotopes = reader.readIsotopes();
        for (IIsotope isotope : isotopes) {
            this.add(isotope);
        }
        if (this.debug) {
            logger.debug("Found #isotopes in file: ", isotopes.size());
        }
    }

    public static XMLIsotopeFactory getInstance(IChemObjectBuilder builder) throws IOException {
        if (ifac == null) {
            ifac = new XMLIsotopeFactory(builder);
        }
        return ifac;
    }
}

