/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;

public class Reaction
extends ChemObject
implements Serializable,
IReaction,
Cloneable {
    private static final long serialVersionUID = -554752558363533678L;
    protected int growArraySize = 3;
    protected IAtomContainerSet reactants = this.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
    protected IAtomContainerSet products = this.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
    protected IAtomContainerSet agents = this.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
    protected IMapping[] map = new Mapping[this.growArraySize];
    protected int mappingCount = 0;
    private IReaction.Direction reactionDirection = IReaction.Direction.FORWARD;

    @Override
    public int getReactantCount() {
        return this.reactants.getAtomContainerCount();
    }

    @Override
    public int getProductCount() {
        return this.products.getAtomContainerCount();
    }

    @Override
    public IAtomContainerSet getReactants() {
        return this.reactants;
    }

    @Override
    public void setReactants(IAtomContainerSet setOfMolecules) {
        this.reactants = setOfMolecules;
        this.notifyChanged();
    }

    @Override
    public IAtomContainerSet getProducts() {
        return this.products;
    }

    @Override
    public void setProducts(IAtomContainerSet setOfMolecules) {
        this.products = setOfMolecules;
        this.notifyChanged();
    }

    @Override
    public IAtomContainerSet getAgents() {
        return this.agents;
    }

    @Override
    public Iterable<IMapping> mappings() {
        return new Iterable<IMapping>(){

            @Override
            public Iterator<IMapping> iterator() {
                return new MappingIterator();
            }
        };
    }

    @Override
    public void addReactant(IAtomContainer reactant) {
        this.addReactant(reactant, 1.0);
    }

    @Override
    public void addAgent(IAtomContainer agent) {
        this.agents.addAtomContainer(agent);
        this.notifyChanged();
    }

    @Override
    public void addReactant(IAtomContainer reactant, Double coefficient) {
        this.reactants.addAtomContainer(reactant, coefficient);
        this.notifyChanged();
    }

    @Override
    public void addProduct(IAtomContainer product) {
        this.addProduct(product, 1.0);
    }

    @Override
    public void addProduct(IAtomContainer product, Double coefficient) {
        this.products.addAtomContainer(product, coefficient);
    }

    @Override
    public Double getReactantCoefficient(IAtomContainer reactant) {
        return this.reactants.getMultiplier(reactant);
    }

    @Override
    public Double getProductCoefficient(IAtomContainer product) {
        return this.products.getMultiplier(product);
    }

    @Override
    public boolean setReactantCoefficient(IAtomContainer reactant, Double coefficient) {
        boolean result = this.reactants.setMultiplier(reactant, coefficient);
        this.notifyChanged();
        return result;
    }

    @Override
    public boolean setProductCoefficient(IAtomContainer product, Double coefficient) {
        boolean result = this.products.setMultiplier(product, coefficient);
        this.notifyChanged();
        return result;
    }

    @Override
    public Double[] getReactantCoefficients() {
        return this.reactants.getMultipliers();
    }

    @Override
    public Double[] getProductCoefficients() {
        return this.products.getMultipliers();
    }

    @Override
    public boolean setReactantCoefficients(Double[] coefficients) {
        boolean result = this.reactants.setMultipliers(coefficients);
        this.notifyChanged();
        return result;
    }

    @Override
    public boolean setProductCoefficients(Double[] coefficients) {
        boolean result = this.products.setMultipliers(coefficients);
        this.notifyChanged();
        return result;
    }

    @Override
    public void setDirection(IReaction.Direction direction) {
        this.reactionDirection = direction;
        this.notifyChanged();
    }

    @Override
    public IReaction.Direction getDirection() {
        return this.reactionDirection;
    }

    @Override
    public void addMapping(IMapping mapping) {
        if (this.mappingCount + 1 >= this.map.length) {
            this.growMappingArray();
        }
        this.map[this.mappingCount] = mapping;
        ++this.mappingCount;
        this.notifyChanged();
    }

    @Override
    public void removeMapping(int pos) {
        for (int i = pos; i < this.mappingCount - 1; ++i) {
            this.map[i] = this.map[i + 1];
        }
        this.map[this.mappingCount - 1] = null;
        --this.mappingCount;
        this.notifyChanged();
    }

    @Override
    public IMapping getMapping(int pos) {
        return this.map[pos];
    }

    @Override
    public int getMappingCount() {
        return this.mappingCount;
    }

    private void growMappingArray() {
        Mapping[] newMap = new Mapping[this.map.length + this.growArraySize];
        System.arraycopy(this.map, 0, newMap, 0, this.map.length);
        this.map = newMap;
    }

    @Override
    public String toString() {
        StringBuffer description = new StringBuffer(64);
        description.append("Reaction(");
        description.append(this.getID());
        description.append(", #M:").append(this.mappingCount);
        description.append(", reactants=").append(this.reactants.toString());
        description.append(", products=").append(this.products.toString());
        description.append(", agents=").append(this.agents.toString());
        description.append(')');
        return description.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Reaction clone = (Reaction)super.clone();
        clone.reactants = (IAtomContainerSet)this.reactants.clone();
        clone.agents = (IAtomContainerSet)this.agents.clone();
        clone.products = (IAtomContainerSet)this.products.clone();
        Hashtable<IAtom, IAtom> atomatom = new Hashtable<IAtom, IAtom>();
        for (int i = 0; i < this.reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = this.reactants.getAtomContainer(i);
            IAtomContainer mol2 = clone.reactants.getAtomContainer(i);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                atomatom.put(mol.getAtom(j), mol2.getAtom(j));
            }
        }
        clone.map = new Mapping[this.map.length];
        for (int f = 0; f < this.mappingCount; ++f) {
            clone.map[f] = new Mapping((IChemObject)atomatom.get(this.map[f].getChemObject(0)), (IChemObject)atomatom.get(this.map[f].getChemObject(1)));
        }
        return clone;
    }

    private class MappingIterator
    implements Iterator<IMapping> {
        private int pointer = 0;

        private MappingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < Reaction.this.mappingCount;
        }

        @Override
        public IMapping next() {
            return Reaction.this.map[this.pointer++];
        }

        @Override
        public void remove() {
            Reaction.this.removeMapping(--this.pointer);
        }
    }
}

