/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.RestrictionImpl;

public class CardinalityRestrictionImpl
extends RestrictionImpl
implements CardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new CardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to CardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, CardinalityRestriction.class);
        }
    };

    public CardinalityRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getCardinality() {
        return this.objectAsInt(this.getProfile().CARDINALITY(), "CARDINALITY");
    }

    @Override
    public boolean hasCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

