/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.ringsearch.RingSearch;

public final class Stereocenters {
    private final IAtomContainer container;
    private final int[][] g;
    private final GraphUtil.EdgeToBondMap bondMap;
    private final Stereocenter[] stereocenters;
    private final StereoElement[] elements;
    private final RingSearch ringSearch;

    public static Stereocenters of(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] g = GraphUtil.toAdjList(container, bondMap);
        return new Stereocenters(container, g, bondMap);
    }

    Stereocenters(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap) {
        this.container = container;
        this.bondMap = bondMap;
        this.g = graph;
        this.ringSearch = new RingSearch(container, graph);
        this.stereocenters = new Stereocenter[graph.length];
        this.elements = new StereoElement[graph.length];
        if (this.createElements() == 0) {
            return;
        }
        int[] symmetry = Stereocenters.toIntArray(Canon.symmetry(container, graph));
        this.labelTrueCenters(symmetry);
        this.labelIsolatedPara(symmetry);
    }

    public Type elementType(int v) {
        if (this.stereocenters[v] == Stereocenter.Non || this.elements[v] == null) {
            return Type.None;
        }
        return this.elements[v].type;
    }

    public boolean isStereocenter(int v) {
        return this.stereocenters[v] == Stereocenter.True || this.stereocenters[v] == Stereocenter.Para;
    }

    public Stereocenter stereocenterType(int v) {
        return this.stereocenters[v];
    }

    private int createElements() {
        boolean[] tricoordinate = new boolean[this.g.length];
        int nElements = 0;
        Arrays.fill((Object[])this.stereocenters, (Object)Stereocenter.Non);
        block9: for (int i = 0; i < this.g.length; ++i) {
            int h = this.container.getAtom(i).getImplicitHydrogenCount();
            int x = this.g[i].length + h;
            int v = h;
            if (x < 2 || x > 4 || h > 1) continue;
            int piNeighbor = 0;
            block10: for (int w : this.g[i]) {
                if (Stereocenters.atomicNumber(this.container.getAtom(w)) == 1) {
                    ++h;
                }
                switch (this.bondMap.get(i, w).getOrder()) {
                    case SINGLE: {
                        ++v;
                        continue block10;
                    }
                    case DOUBLE: {
                        v += 2;
                        piNeighbor = w;
                        continue block10;
                    }
                    default: {
                        continue block9;
                    }
                }
            }
            switch (this.supportedType(i, v, h, x)) {
                case Bicoordinate: {
                    this.stereocenters[i] = Stereocenter.Potential;
                    this.elements[i] = new Bicoordinate(i, this.g[i]);
                    ++nElements;
                    int u = this.g[i][0];
                    int w = this.g[i][1];
                    if (tricoordinate[u]) {
                        this.stereocenters[u] = Stereocenter.Potential;
                        this.elements[u] = new Tricoordinate(u, i, this.g[u]);
                    }
                    if (!tricoordinate[w]) continue block9;
                    this.stereocenters[w] = Stereocenter.Potential;
                    this.elements[w] = new Tricoordinate(w, i, this.g[w]);
                    continue block9;
                }
                case Tricoordinate: {
                    int u = i;
                    int w = piNeighbor;
                    tricoordinate[u] = true;
                    if (!tricoordinate[w]) {
                        if (this.elements[w] == null || this.elements[w].type != Type.Bicoordinate) continue block9;
                        this.stereocenters[u] = Stereocenter.Potential;
                        this.elements[u] = new Tricoordinate(u, w, this.g[u]);
                        continue block9;
                    }
                    if (this.ringSearch.cyclic(w, u)) continue block9;
                    this.stereocenters[w] = Stereocenter.Potential;
                    this.stereocenters[u] = Stereocenter.Potential;
                    this.elements[u] = new Tricoordinate(u, w, this.g[u]);
                    this.elements[w] = new Tricoordinate(w, u, this.g[w]);
                    ++nElements;
                    continue block9;
                }
                case Tetracoordinate: {
                    this.elements[i] = new Tetracoordinate(i, this.g[i]);
                    this.stereocenters[i] = Stereocenter.Potential;
                    ++nElements;
                    continue block9;
                }
                default: {
                    this.stereocenters[i] = Stereocenter.Non;
                }
            }
        }
        for (int v = 0; v < this.g.length; ++v) {
            if (this.elements[v] == null || this.elements[v].type != Type.Bicoordinate) continue;
            int u = this.elements[v].neighbors[0];
            int w = this.elements[v].neighbors[1];
            if (this.elements[u] == null || this.elements[w] == null || this.elements[u].type != Type.Tricoordinate || this.elements[w].type != Type.Tricoordinate) continue;
            ((Tricoordinate)this.elements[u]).other = w;
            ((Tricoordinate)this.elements[w]).other = u;
        }
        return nElements;
    }

    private void labelTrueCenters(int[] symmetry) {
        boolean[] visited = new boolean[symmetry.length + 1];
        for (int v = 0; v < this.g.length; ++v) {
            if (this.stereocenters[v] != Stereocenter.Potential) continue;
            int[] ws = this.elements[v].neighbors;
            int nUnique = 0;
            boolean terminal = true;
            for (int w : ws) {
                if (!visited[symmetry[w]]) {
                    visited[symmetry[w]] = true;
                    ++nUnique;
                    continue;
                }
                if (this.g[w].length <= 1) continue;
                terminal = false;
            }
            for (int w : ws) {
                visited[symmetry[w]] = false;
            }
            if (nUnique == ws.length) {
                this.stereocenters[v] = Stereocenter.True;
                continue;
            }
            if (!terminal) continue;
            this.stereocenters[v] = Stereocenter.Non;
        }
    }

    private void labelIsolatedPara(int[] symmetry) {
        boolean[] visited = new boolean[symmetry.length + 1];
        for (int[] isolated : this.ringSearch.isolated()) {
            ArrayList<StereoElement> potential = new ArrayList<StereoElement>();
            ArrayList<StereoElement> trueCentres = new ArrayList<StereoElement>();
            BitSet cyclic = new BitSet();
            for (int v : isolated) {
                cyclic.set(v);
                if (this.stereocenters[v] == Stereocenter.Potential) {
                    potential.add(this.elements[v]);
                    continue;
                }
                if (this.stereocenters[v] != Stereocenter.True) continue;
                trueCentres.add(this.elements[v]);
            }
            if (potential.size() + trueCentres.size() < 2) {
                for (StereoElement element : potential) {
                    this.stereocenters[element.focus] = Stereocenter.Non;
                }
                continue;
            }
            ArrayList<StereoElement> paraElements = new ArrayList<StereoElement>();
            for (StereoElement element : potential) {
                if (element.type == Type.Tetracoordinate) {
                    int[] ws = element.neighbors;
                    int nUnique = 0;
                    boolean terminal = true;
                    for (int w : ws) {
                        if (cyclic.get(w)) continue;
                        if (!visited[symmetry[w]]) {
                            visited[symmetry[w]] = true;
                            ++nUnique;
                            continue;
                        }
                        if (this.g[w].length <= 1) continue;
                        terminal = false;
                    }
                    for (int w : ws) {
                        visited[symmetry[w]] = false;
                    }
                    int deg = this.g[element.focus].length;
                    if (deg == 3 || deg == 4 && nUnique == 2) {
                        paraElements.add(element);
                    }
                    if (deg != 4 || nUnique != 1 || !terminal) continue;
                    this.stereocenters[element.focus] = Stereocenter.Non;
                    continue;
                }
                if (element.type != Type.Tricoordinate) continue;
                Tricoordinate either = (Tricoordinate)element;
                if (this.stereocenters[either.other] != Stereocenter.True) continue;
                paraElements.add(element);
            }
            if (paraElements.size() + trueCentres.size() >= 2) {
                for (StereoElement para : paraElements) {
                    this.stereocenters[para.focus] = Stereocenter.Para;
                }
                continue;
            }
            for (StereoElement para : paraElements) {
                this.stereocenters[para.focus] = Stereocenter.Non;
            }
        }
    }

    private Type supportedType(int i, int v, int h, int x) {
        IAtom atom = this.container.getAtom(i);
        int q = Stereocenters.charge(atom);
        if (h > 1) {
            return Type.None;
        }
        switch (Stereocenters.atomicNumber(atom)) {
            case 0: {
                return Type.None;
            }
            case 5: {
                return q == -1 && v == 4 && x == 4 ? Type.Tetracoordinate : Type.None;
            }
            case 6: {
                if (v != 4 || q != 0) {
                    return Type.None;
                }
                if (x == 2) {
                    return Type.Bicoordinate;
                }
                if (x == 3) {
                    return Type.Tricoordinate;
                }
                if (x == 4) {
                    return Type.Tetracoordinate;
                }
                return Type.None;
            }
            case 7: {
                if (x == 2 && v == 3 && h == 0 && q == 0) {
                    return Type.Tricoordinate;
                }
                if (x == 3 && v == 4 && q == 1) {
                    return Type.Tricoordinate;
                }
                if (x == 4 && h == 0 && (q == 0 && v == 5 || q == 1 && v == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                return x == 3 && h == 0 && this.inThreeMemberRing(i) ? Type.Tetracoordinate : Type.None;
            }
            case 14: {
                if (v != 4 || q != 0) {
                    return Type.None;
                }
                if (x == 3) {
                    return Type.Tricoordinate;
                }
                if (x == 4) {
                    return Type.Tetracoordinate;
                }
                return Type.None;
            }
            case 15: {
                if (x == 4 && (q == 0 && v == 5 && h == 0 || q == 1 && v == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                if (x == 3 && q == 0 && v == 3 && h == 0) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
            }
            case 16: {
                if (h > 0) {
                    return Type.None;
                }
                if (q == 0 && (v == 4 && x == 3 || v == 6 && x == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                if (q == 1 && (v == 3 && x == 3 || v == 5 && x == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                return Type.None;
            }
            case 32: {
                if (v != 4 || q != 0) {
                    return Type.None;
                }
                if (x == 3) {
                    return Type.Tricoordinate;
                }
                if (x == 4) {
                    return Type.Tetracoordinate;
                }
                return Type.None;
            }
            case 33: {
                if (x == 4 && q == 1 && v == 4) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                return Type.None;
            }
            case 34: {
                if (h > 0) {
                    return Type.None;
                }
                if (q == 0 && (v == 4 && x == 3 || v == 6 && x == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                if (q == 1 && (v == 3 && x == 3 || v == 5 && x == 4)) {
                    return this.verifyTerminalHCount(i) ? Type.Tetracoordinate : Type.None;
                }
                return Type.None;
            }
            case 50: {
                return q == 0 && v == 4 && x == 4 ? Type.Tetracoordinate : Type.None;
            }
        }
        return Type.None;
    }

    private boolean verifyTerminalHCount(int v) {
        int[] counts = new int[6];
        int[][] atoms = new int[6][this.g[v].length];
        boolean found = false;
        for (int w : this.g[v]) {
            int idx;
            int n = idx = Stereocenters.indexNeighbor(this.container.getAtom(w));
            int n2 = counts[n];
            counts[n] = n2 + 1;
            atoms[idx][n2] = w;
            found = found || idx > 0 && counts[idx] > 1;
        }
        if (!found) {
            return true;
        }
        for (int i = 1; i < counts.length; ++i) {
            if (counts[i] < 2) continue;
            int terminalCount = 0;
            int terminalHCount = 0;
            for (int j = 0; j < counts[i]; ++j) {
                int hCount = 0;
                int[] ws = this.g[atoms[i][j]];
                for (int w : this.g[atoms[i][j]]) {
                    if (Stereocenters.atomicNumber(this.container.getAtom(w)) != 1) continue;
                    ++hCount;
                }
                if (ws.length - hCount != 1) continue;
                ++terminalCount;
                terminalHCount += hCount + this.container.getAtom(atoms[i][j]).getImplicitHydrogenCount();
            }
            if (terminalCount <= true || terminalHCount <= 0) continue;
            return false;
        }
        return true;
    }

    private static int indexNeighbor(IAtom atom) {
        switch (Stereocenters.atomicNumber(atom)) {
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 34: {
                return 4;
            }
            case 52: {
                return 5;
            }
        }
        return 0;
    }

    private boolean inThreeMemberRing(int v) {
        BitSet adj = new BitSet();
        for (int w : this.g[v]) {
            adj.set(w);
        }
        for (int w : this.g[v]) {
            for (int u : this.g[w]) {
                if (!adj.get(u)) continue;
                return true;
            }
        }
        return false;
    }

    private static int atomicNumber(IAtom a) {
        Integer elem = a.getAtomicNumber();
        if (elem != null) {
            return elem;
        }
        if (a instanceof IPseudoAtom) {
            return 0;
        }
        throw new IllegalArgumentException("an atom had an undefieind atomic number");
    }

    private static int charge(IAtom a) {
        Integer chg = a.getFormalCharge();
        return chg != null ? chg : 0;
    }

    private static int[] toIntArray(long[] org) {
        int[] cpy = new int[org.length];
        for (int i = 0; i < cpy.length; ++i) {
            cpy[i] = (int)org[i];
        }
        return cpy;
    }

    private static final class Tricoordinate
    extends StereoElement {
        int other;

        Tricoordinate(int v, int w, int[] neighbors) {
            this.focus = v;
            this.other = w;
            this.type = Type.Tricoordinate;
            this.neighbors = new int[neighbors.length - 1];
            int n = 0;
            for (int i = 0; i < neighbors.length; ++i) {
                if (neighbors[i] == this.other) continue;
                this.neighbors[n++] = neighbors[i];
            }
        }
    }

    private static final class Tetracoordinate
    extends StereoElement {
        Tetracoordinate(int v, int[] neighbors) {
            this.focus = v;
            this.type = Type.Tetracoordinate;
            this.neighbors = Arrays.copyOf(neighbors, neighbors.length);
        }
    }

    private static final class Bicoordinate
    extends StereoElement {
        Bicoordinate(int v, int[] neighbors) {
            this.focus = v;
            this.type = Type.Bicoordinate;
            this.neighbors = Arrays.copyOf(neighbors, neighbors.length);
        }
    }

    private static abstract class StereoElement {
        int focus;
        int[] neighbors;
        Type type;

        private StereoElement() {
        }
    }

    public static enum Type {
        Bicoordinate,
        Tricoordinate,
        Tetracoordinate,
        None;

    }

    public static enum Stereocenter {
        True,
        Para,
        Potential,
        Non;

    }
}

