/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.FormatStringBuffer;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

@TestClass(value="org.openscience.cdk.io.PDBWriterTest")
public class PDBWriter
extends DefaultChemObjectWriter {
    public final String SERIAL_FORMAT = "%5d";
    public final String ATOM_NAME_FORMAT = "%-5s";
    public final String POSITION_FORMAT = "%8.3f";
    public final String RESIDUE_FORMAT = "%s";
    private BooleanIOSetting writeAsHET;
    private BooleanIOSetting useElementSymbolAsAtomName;
    private BooleanIOSetting writeCONECTRecords;
    private BooleanIOSetting writeTERRecord;
    private BooleanIOSetting writeENDRecord;
    private BufferedWriter writer;

    public PDBWriter() {
        this(new StringWriter());
    }

    public PDBWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeAsHET = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteAsHET", IOSetting.Importance.LOW, "Should the output file use HETATM", "false"));
        this.useElementSymbolAsAtomName = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("UseElementSymbolAsAtomName", IOSetting.Importance.LOW, "Should the element symbol be written as the atom name", "false"));
        this.writeCONECTRecords = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteCONECT", IOSetting.Importance.LOW, "Should the bonds be written as CONECT records?", "true"));
        this.writeTERRecord = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteTER", IOSetting.Importance.LOW, "Should a TER record be put at the end of the atoms?", "false"));
        this.writeENDRecord = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteEND", IOSetting.Importance.LOW, "Should an END record be put at the end of the file?", "true"));
    }

    public PDBWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PDBFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (ICrystal.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (ICrystal.class.equals(interfaces[i])) {
                return true;
            }
            if (IAtomContainer.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (object instanceof ICrystal) {
            this.writeCrystal((ICrystal)object);
        } else if (object instanceof IAtomContainer) {
            this.writeMolecule((IAtomContainer)object);
        } else if (object instanceof IChemFile) {
            IChemModel model;
            IChemFile chemFile = (IChemFile)object;
            IChemSequence sequence = chemFile.getChemSequence(0);
            if (sequence != null && (model = sequence.getChemModel(0)) != null) {
                ICrystal crystal = model.getCrystal();
                if (crystal != null) {
                    this.write(crystal);
                } else {
                    Iterator<IAtomContainer> containers = ChemModelManipulator.getAllAtomContainers(model).iterator();
                    while (containers.hasNext()) {
                        this.writeMolecule(model.getBuilder().newInstance(IAtomContainer.class, containers.next()));
                    }
                }
            }
        } else {
            throw new CDKException("Only supported is writing of Molecule, Crystal and ChemFile objects.");
        }
    }

    public void writeMolecule(IAtomContainer molecule) throws CDKException {
        try {
            this.writeHeader();
            int atomNumber = 1;
            String hetatmRecordName = this.writeAsHET.isSet() ? "HETATM" : "ATOM  ";
            String id = molecule.getID();
            String residueName = id == null || id.equals("") ? "MOL" : id;
            String terRecordName = "TER";
            StringBuffer buffer = new StringBuffer();
            Iterator<IAtom> atoms = molecule.atoms().iterator();
            FormatStringBuffer fsb = new FormatStringBuffer("");
            String[] connectRecords = null;
            if (this.writeCONECTRecords.isSet()) {
                connectRecords = new String[molecule.getAtomCount()];
            }
            while (atoms.hasNext()) {
                buffer.setLength(0);
                buffer.append(hetatmRecordName);
                fsb.reset("%5d").format(atomNumber);
                buffer.append(fsb.toString());
                buffer.append(' ');
                IAtom atom = atoms.next();
                String name = this.useElementSymbolAsAtomName.isSet() ? atom.getSymbol() : (atom.getID() == null || atom.getID().equals("") ? atom.getSymbol() : atom.getID());
                fsb.reset("%-5s").format(name);
                buffer.append(fsb.toString());
                fsb.reset("%s").format(residueName);
                buffer.append(fsb).append("     0    ");
                Point3d position = atom.getPoint3d();
                fsb.reset("%8.3f").format(position.x);
                buffer.append(fsb.toString());
                fsb.reset("%8.3f").format(position.y);
                buffer.append(fsb.toString());
                fsb.reset("%8.3f").format(position.z);
                buffer.append(fsb.toString());
                buffer.append("  1.00");
                buffer.append("  0.00");
                buffer.append("           ");
                buffer.append(atom.getSymbol());
                Integer formalCharge = atom.getFormalCharge();
                if (formalCharge == CDKConstants.UNSET) {
                    buffer.append("+0");
                } else if (formalCharge < 0) {
                    buffer.append(formalCharge);
                } else {
                    buffer.append("+").append(formalCharge);
                }
                if (connectRecords != null && this.writeCONECTRecords.isSet()) {
                    List<IAtom> neighbours = molecule.getConnectedAtomsList(atom);
                    if (neighbours.size() != 0) {
                        StringBuffer connectBuffer = new StringBuffer("CONECT");
                        connectBuffer.append(String.format("%5d", atomNumber));
                        for (IAtom neighbour : neighbours) {
                            int neighbourNumber = molecule.getAtomNumber(neighbour) + 1;
                            connectBuffer.append(String.format("%5d", neighbourNumber));
                        }
                        connectRecords[atomNumber - 1] = connectBuffer.toString();
                    } else {
                        connectRecords[atomNumber - 1] = null;
                    }
                }
                this.writer.write(buffer.toString(), 0, buffer.length());
                this.writer.newLine();
                ++atomNumber;
            }
            if (this.writeTERRecord.isSet()) {
                this.writer.write(terRecordName, 0, terRecordName.length());
                this.writer.newLine();
            }
            if (connectRecords != null && this.writeCONECTRecords.isSet()) {
                for (String connectRecord : connectRecords) {
                    if (connectRecord == null) continue;
                    this.writer.write(connectRecord);
                    this.writer.newLine();
                }
            }
            if (this.writeENDRecord.isSet()) {
                this.writer.write("END   ");
                this.writer.newLine();
            }
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing file: " + exception.getMessage(), exception);
        }
    }

    private void writeHeader() throws IOException {
        this.writer.write("HEADER created with the CDK (http://cdk.sf.net/)");
        this.writer.newLine();
    }

    public void writeCrystal(ICrystal crystal) throws CDKException {
        try {
            this.writeHeader();
            Vector3d a = crystal.getA();
            Vector3d b = crystal.getB();
            Vector3d c = crystal.getC();
            double[] ucParams = CrystalGeometryTools.cartesianToNotional(a, b, c);
            String LENGTH_FORMAT = "%4.3f";
            String ANGLE_FORMAT = "%3.3f";
            FormatStringBuffer fsb = new FormatStringBuffer("");
            fsb.reset("%4.3f").format(ucParams[0]);
            this.writer.write("CRYST1 " + fsb.toString());
            fsb.reset("%4.3f").format(ucParams[1]);
            this.writer.write(fsb.toString());
            fsb.reset("%4.3f").format(ucParams[2]);
            this.writer.write(fsb.toString());
            fsb.reset("%3.3f").format(ucParams[3]);
            this.writer.write(fsb.toString());
            fsb.reset("%3.3f").format(ucParams[4]);
            this.writer.write(fsb.toString());
            fsb.reset("%3.3f").format(ucParams[4]);
            this.writer.write(fsb.toString());
            this.writer.newLine();
            for (IAtom atom : crystal.atoms()) {
                if (atom.getPoint3d() != null || atom.getFractionalPoint3d() == null) continue;
                Point3d frac = new Point3d(atom.getFractionalPoint3d());
                Point3d cart = CrystalGeometryTools.fractionalToCartesian(a, b, c, frac);
                atom.setPoint3d(cart);
            }
            this.writeMolecule(crystal.getBuilder().newInstance(IAtomContainer.class, crystal));
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing file: " + exception.getMessage(), exception);
        }
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }
}

