/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GreedyBasis;
import org.openscience.cdk.graph.InitialCycles;

@TestClass(value="org.openscience.cdk.graph.RelevantCyclesTest")
public final class RelevantCycles {
    private final GreedyBasis basis;

    @TestMethod(value="noGraph")
    public RelevantCycles(int[][] graph) {
        this(new InitialCycles(graph));
    }

    @TestMethod(value="noInitialCycles")
    RelevantCycles(InitialCycles initial) {
        Preconditions.checkNotNull(initial, "No InitialCycles provided");
        this.basis = new GreedyBasis(initial.numberOfCycles(), initial.numberOfEdges());
        for (int length : initial.lengths()) {
            this.basis.addAll(this.independent(initial.cyclesOfLength(length)));
        }
    }

    private List<InitialCycles.Cycle> independent(Collection<InitialCycles.Cycle> cycles) {
        ArrayList<InitialCycles.Cycle> independent = new ArrayList<InitialCycles.Cycle>(cycles.size());
        for (InitialCycles.Cycle cycle : cycles) {
            if (!this.basis.isIndependent(cycle)) continue;
            independent.add(cycle);
        }
        return independent;
    }

    @TestMethod(value="paths_bicyclo,paths_napthalene,paths_anthracene,paths_cyclophane_odd,paths_cyclophane_even")
    public int[][] paths() {
        int[][] paths = new int[this.size()][0];
        int i = 0;
        for (InitialCycles.Cycle c : this.basis.members()) {
            for (int[] path : c.family()) {
                paths[i++] = path;
            }
        }
        return paths;
    }

    @TestMethod(value="size_bicyclo,size_napthalene,size_anthracene,size_cyclophane_odd,size_cyclophane_even")
    public int size() {
        int size = 0;
        for (InitialCycles.Cycle c : this.basis.members()) {
            size += c.sizeOfFamily();
        }
        return size;
    }
}

