/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.cip.CIPTool;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.CombinedAtomicMassNumberRule;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;

@TestClass(value="org.openscience.cdk.geometry.cip.rules.CIPLigandRuleTest")
public class CIPLigandRule
implements ISequenceSubRule<ILigand> {
    CombinedAtomicMassNumberRule numberRule = new CombinedAtomicMassNumberRule();

    @Override
    @TestMethod(value="testCompare,testCompare_Identity,testOrder")
    public int compare(ILigand ligand1, ILigand ligand2) {
        int comparison;
        int i;
        int numberComp = this.numberRule.compare(ligand1, ligand2);
        if (numberComp != 0) {
            return numberComp;
        }
        ILigand[] ligand1Ligands = CIPTool.getLigandLigands(ligand1);
        ILigand[] ligand2Ligands = CIPTool.getLigandLigands(ligand2);
        if (ligand1Ligands.length == 0 && ligand2Ligands.length == 0) {
            return 0;
        }
        if (ligand1Ligands.length == 0) {
            return -1;
        }
        if (ligand2Ligands.length == 0) {
            return 1;
        }
        int minLigandCount = Math.min(ligand1Ligands.length, ligand2Ligands.length);
        if (ligand1Ligands.length > 1) {
            ligand1Ligands = this.order(ligand1Ligands);
        }
        if (ligand2Ligands.length > 1) {
            ligand2Ligands = this.order(ligand2Ligands);
        }
        for (i = 0; i < minLigandCount; ++i) {
            comparison = this.numberRule.compare(ligand1Ligands[i], ligand2Ligands[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        if (ligand1Ligands.length == ligand2Ligands.length) {
            for (i = 0; i < minLigandCount; ++i) {
                comparison = this.compare(ligand1Ligands[i], ligand2Ligands[i]);
                if (comparison == 0) continue;
                return comparison;
            }
        }
        if (ligand1Ligands.length > ligand2Ligands.length) {
            return 1;
        }
        if (ligand1Ligands.length < ligand2Ligands.length) {
            return -1;
        }
        return 0;
    }

    private ILigand[] order(ILigand[] ligands) {
        ILigand[] newLigands = new ILigand[ligands.length];
        System.arraycopy(ligands, 0, newLigands, 0, ligands.length);
        Arrays.sort(newLigands, this.numberRule);
        ILigand[] reverseLigands = new ILigand[newLigands.length];
        for (int i = 0; i < newLigands.length; ++i) {
            reverseLigands[newLigands.length - 1 - i] = newLigands[i];
        }
        return reverseLigands;
    }
}

