/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.Polymer;
import org.openscience.cdk.debug.DebugAtomContainer;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPolymer;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugPolymer
extends Polymer
implements IPolymer {
    private static final long serialVersionUID = -1459933635059023539L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAtomContainer.class);

    @Override
    public void addStereoElement(IStereoElement parity) {
        this.logger.debug("Adding stereo element: ", parity);
        super.addStereoElement(parity);
    }

    @Override
    public Iterable<IStereoElement> stereoElements() {
        this.logger.debug("Getting stereo elements.");
        return super.stereoElements();
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.logger.debug("Setting atoms: ", atoms.length);
        super.setAtoms(atoms);
    }

    @Override
    public void setAtom(int number, IAtom atom) {
        this.logger.debug("Setting atom at: pos=" + number, " atom=" + atom);
        super.setAtom(number, atom);
    }

    @Override
    public IAtom getAtom(int number) {
        this.logger.debug("Getting atom at: ", number);
        return super.getAtom(number);
    }

    @Override
    public IBond getBond(int number) {
        this.logger.debug("Getting bond at: ", number);
        return super.getBond(number);
    }

    @Override
    public ILonePair getLonePair(int number) {
        this.logger.debug("Getting lone pair at: ", number);
        return super.getLonePair(number);
    }

    @Override
    public ISingleElectron getSingleElectron(int number) {
        this.logger.debug("Getting single electron at: ", number);
        return super.getSingleElectron(number);
    }

    @Override
    public Iterable<IAtom> atoms() {
        this.logger.debug("Getting atoms iterator");
        return super.atoms();
    }

    @Override
    public Iterable<IBond> bonds() {
        this.logger.debug("Getting bonds iterator");
        return super.bonds();
    }

    @Override
    public Iterable<ILonePair> lonePairs() {
        this.logger.debug("Getting lone pairs iterator");
        return super.lonePairs();
    }

    @Override
    public Iterable<ISingleElectron> singleElectrons() {
        this.logger.debug("Getting single electrons iterator");
        return super.singleElectrons();
    }

    @Override
    public Iterable<IElectronContainer> electronContainers() {
        this.logger.debug("Getting electron containers iterator");
        return super.electronContainers();
    }

    @Override
    public IAtom getFirstAtom() {
        this.logger.debug("Getting first atom: ", super.getFirstAtom());
        return super.getFirstAtom();
    }

    @Override
    public IAtom getLastAtom() {
        this.logger.debug("Getting last atom: ", super.getLastAtom());
        return super.getLastAtom();
    }

    @Override
    public int getAtomNumber(IAtom atom) {
        this.logger.debug("Getting atom number: ", atom);
        return super.getAtomNumber(atom);
    }

    @Override
    public int getBondNumber(IAtom atom1, IAtom atom2) {
        this.logger.debug("Getting bond number: atom1=" + atom1, " atom2=" + atom2);
        return super.getBondNumber(atom1, atom2);
    }

    @Override
    public int getBondNumber(IBond bond) {
        this.logger.debug("Getting bond number: ", bond);
        return super.getBondNumber(bond);
    }

    @Override
    public int getLonePairNumber(ILonePair bond) {
        this.logger.debug("Getting lone pair number: ", bond);
        return super.getLonePairNumber(bond);
    }

    @Override
    public int getSingleElectronNumber(ISingleElectron bond) {
        this.logger.debug("Getting single electron number: ", bond);
        return super.getSingleElectronNumber(bond);
    }

    @Override
    public IElectronContainer getElectronContainer(int number) {
        this.logger.debug("Getting electron container at: ", number);
        return super.getElectronContainer(number);
    }

    @Override
    public IBond getBond(IAtom atom1, IAtom atom2) {
        this.logger.debug("Getting bond for atoms: atom1=" + atom1, " atom2=" + atom2);
        return super.getBond(atom1, atom2);
    }

    @Override
    public int getAtomCount() {
        this.logger.debug("Getting atom count");
        return super.getAtomCount();
    }

    @Override
    public int getBondCount() {
        this.logger.debug("Getting bond count");
        return super.getBondCount();
    }

    @Override
    public int getLonePairCount() {
        this.logger.debug("Getting lone pair count");
        return super.getLonePairCount();
    }

    @Override
    public int getSingleElectronCount() {
        this.logger.debug("Getting single electron count");
        return super.getSingleElectronCount();
    }

    @Override
    public int getElectronContainerCount() {
        this.logger.debug("Getting electron container count");
        return super.getElectronContainerCount();
    }

    @Override
    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        this.logger.debug("Getting connecting atoms vector for atom: ", atom);
        return super.getConnectedAtomsList(atom);
    }

    @Override
    public List<IBond> getConnectedBondsList(IAtom atom) {
        this.logger.debug("Getting connected bonds vector for atom: ", atom);
        return super.getConnectedBondsList(atom);
    }

    @Override
    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        this.logger.debug("Getting lone pairs at atom: atom=" + atom, " lone pairs=" + super.getConnectedLonePairsCount(atom));
        return super.getConnectedLonePairsList(atom);
    }

    @Override
    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        this.logger.debug("Getting single electrons at atom: atom=" + atom, " single electrons=" + super.getConnectedSingleElectronsCount(atom));
        return super.getConnectedSingleElectronsList(atom);
    }

    @Override
    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        this.logger.debug("Getting connected electron containers for atom: ", atom);
        return super.getConnectedElectronContainersList(atom);
    }

    @Override
    public int getConnectedAtomsCount(IAtom atom) {
        this.logger.debug("Getting connected atoms count for atom: ", atom);
        return super.getConnectedAtomsCount(atom);
    }

    @Override
    public int getConnectedBondsCount(IAtom atom) {
        this.logger.debug("Getting connected bonds count for atom: ", atom);
        return super.getConnectedBondsCount(atom);
    }

    @Override
    public int getConnectedLonePairsCount(IAtom atom) {
        this.logger.debug("Getting connected lone pairs count for atom: ", atom);
        return super.getConnectedLonePairsCount(atom);
    }

    @Override
    public int getConnectedSingleElectronsCount(IAtom atom) {
        this.logger.debug("Getting connected single electrons count for atom: ", atom);
        return super.getConnectedSingleElectronsCount(atom);
    }

    @Override
    public double getBondOrderSum(IAtom atom) {
        this.logger.debug("Getting bond order sum for atom: ", atom);
        return super.getBondOrderSum(atom);
    }

    @Override
    public IBond.Order getMaximumBondOrder(IAtom atom) {
        this.logger.debug("Getting maximum bond order for atom: ", atom);
        return super.getMaximumBondOrder(atom);
    }

    @Override
    public IBond.Order getMinimumBondOrder(IAtom atom) {
        this.logger.debug("Getting minimum bond order for atom: ", atom);
        return super.getMinimumBondOrder(atom);
    }

    @Override
    public void add(IAtomContainer atomContainer) {
        this.logger.debug("Adding atom container: ", atomContainer);
        super.add(atomContainer);
    }

    @Override
    public void addAtom(IAtom atom) {
        this.logger.debug("Adding atom: ", atom);
        super.addAtom(atom);
    }

    @Override
    public void addBond(IBond bond) {
        this.logger.debug("Adding bond: ", bond);
        super.addBond(bond);
    }

    @Override
    public void addLonePair(ILonePair ec) {
        this.logger.debug("Adding lone pair: ", ec);
        super.addLonePair(ec);
    }

    @Override
    public void addSingleElectron(ISingleElectron ec) {
        this.logger.debug("Adding single electron: ", ec);
        super.addSingleElectron(ec);
    }

    @Override
    public void addElectronContainer(IElectronContainer electronContainer) {
        this.logger.debug("Adding electron container: ", electronContainer);
        super.addElectronContainer(electronContainer);
    }

    @Override
    public void remove(IAtomContainer atomContainer) {
        this.logger.debug("Removing atom container: ", atomContainer);
        super.remove(atomContainer);
    }

    @Override
    public IElectronContainer removeElectronContainer(int position) {
        this.logger.debug("Removing electronContainer: ", position);
        return super.removeElectronContainer(position);
    }

    @Override
    public void removeElectronContainer(IElectronContainer electronContainer) {
        this.logger.debug("Removing electron container: ", electronContainer);
        super.removeElectronContainer(electronContainer);
    }

    @Override
    public void removeAtom(int position) {
        this.logger.debug("Removing atom: ", position);
        super.removeAtom(position);
    }

    @Override
    public void removeAtom(IAtom atom) {
        this.logger.debug("Removing atom: ", atom);
        super.removeAtom(atom);
    }

    @Override
    public IBond removeBond(int pos) {
        this.logger.debug("Removing bond at " + pos);
        return super.removeBond(pos);
    }

    @Override
    public IBond removeBond(IAtom atom1, IAtom atom2) {
        this.logger.debug("Removing bond: atom1=" + atom1 + " atom2=" + atom2);
        return super.removeBond(atom1, atom2);
    }

    @Override
    public void removeBond(IBond bond) {
        this.logger.debug("Removing bond=" + bond);
        super.removeBond(bond);
    }

    @Override
    public ILonePair removeLonePair(int pos) {
        this.logger.debug("Removing bond at " + pos);
        return super.removeLonePair(pos);
    }

    @Override
    public void removeLonePair(ILonePair ec) {
        this.logger.debug("Removing bond=" + ec);
        super.removeLonePair(ec);
    }

    @Override
    public ISingleElectron removeSingleElectron(int pos) {
        this.logger.debug("Removing bond at " + pos);
        return super.removeSingleElectron(pos);
    }

    @Override
    public void removeSingleElectron(ISingleElectron ec) {
        this.logger.debug("Removing bond=" + ec);
        super.removeSingleElectron(ec);
    }

    @Override
    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        this.logger.debug("Removing atom and connected electron containers: ", atom);
        super.removeAtomAndConnectedElectronContainers(atom);
    }

    @Override
    public void removeAllElements() {
        this.logger.debug("Removing all elements");
        super.removeAllElements();
    }

    @Override
    public void removeAllElectronContainers() {
        this.logger.debug("Removing all electron containers");
        super.removeAllElectronContainers();
    }

    @Override
    public void removeAllBonds() {
        this.logger.debug("Removing all bonds");
        super.removeAllBonds();
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        this.logger.debug("Adding bond: atom1=" + atom1 + " atom2=" + atom2, " order=" + (Object)((Object)order) + " stereo=" + (Object)((Object)stereo));
        super.addBond(atom1, atom2, order, stereo);
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order) {
        this.logger.debug("Adding bond: atom1=" + atom1 + " atom2=" + atom2, " order=" + (Object)((Object)order));
        super.addBond(atom1, atom2, order);
    }

    @Override
    public void addLonePair(int atomID) {
        this.logger.debug("Adding lone pair: ", atomID);
        super.addLonePair(atomID);
    }

    @Override
    public void addSingleElectron(int atomID) {
        this.logger.debug("Adding single electron: ", atomID);
        super.addSingleElectron(atomID);
    }

    @Override
    public boolean contains(IAtom atom) {
        this.logger.debug("Contains atom: ", atom);
        return super.contains(atom);
    }

    @Override
    public boolean contains(IBond bond) {
        this.logger.debug("Contains bond: ", bond);
        return super.contains(bond);
    }

    @Override
    public boolean contains(ILonePair ec) {
        this.logger.debug("Contains lone pair: ", ec);
        return super.contains(ec);
    }

    @Override
    public boolean contains(ISingleElectron ec) {
        this.logger.debug("Contains single electron: ", ec);
        return super.contains(ec);
    }

    @Override
    public boolean contains(IElectronContainer electronContainer) {
        this.logger.debug("Contains electron container: ", electronContainer);
        return super.contains(electronContainer);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.addProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public IPolymer clone() throws CloneNotSupportedException {
        IPolymer clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
        this.logger.debug("Receiving state changed event: ", event);
        super.stateChanged(event);
    }

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer) {
        this.logger.debug("Adding atom to monomer: ", oAtom, oMonomer);
        super.addAtom(oAtom, oMonomer);
    }

    @Override
    public int getMonomerCount() {
        this.logger.debug("Getting monomer count: ", super.getMonomerCount());
        return super.getMonomerCount();
    }

    @Override
    public IMonomer getMonomer(String cName) {
        this.logger.debug("Getting monomer for String: ", cName);
        return super.getMonomer(cName);
    }

    @Override
    public Collection<String> getMonomerNames() {
        this.logger.debug("Getting monomer names");
        return super.getMonomerNames();
    }

    @Override
    public void removeMonomer(String name) {
        this.logger.debug("Removing monomer by string: ", name);
        super.removeMonomer(name);
    }
}

