/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.charges.PiElectronegativityTest")
public class PiElectronegativity {
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
    private int maxI = 6;
    private int maxRS = 50;
    private IAtomContainer molPi;
    private IAtomContainer acOldP;
    private double[][] gasteigerFactors;

    public PiElectronegativity() {
        this(6, 50);
    }

    public PiElectronegativity(int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
    }

    @TestMethod(value="testCalculatePiElectronegativity_IAtomContainer_IAtom")
    public double calculatePiElectronegativity(IAtomContainer ac, IAtom atom) {
        return this.calculatePiElectronegativity(ac, atom, this.maxI, this.maxRS);
    }

    @TestMethod(value="testCalculatePiElectronegativity_IAtomContainer_IAtom_Int_Int")
    public double calculatePiElectronegativity(IAtomContainer ac, IAtom atom, int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
        double electronegativity = 0.0;
        try {
            if (!ac.equals(this.acOldP)) {
                this.molPi = ac.getBuilder().newInstance(IAtomContainer.class, ac);
                this.peoe = new GasteigerMarsiliPartialCharges();
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(this.molPi, true);
                IAtomContainerSet iSet = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                iSet.addAtomContainer(this.molPi);
                iSet.addAtomContainer(this.molPi);
                this.gasteigerFactors = this.pepe.assignrPiMarsilliFactors(iSet);
                this.acOldP = ac;
            }
            IAtom atomi = this.molPi.getAtom(ac.getAtomNumber(atom));
            int atomPosition = this.molPi.getAtomNumber(atomi);
            int stepSize = this.pepe.getStepSize();
            int start = stepSize * atomPosition + atomPosition;
            double q = atomi.getCharge();
            if (this.molPi.getConnectedLonePairsCount(this.molPi.getAtom(atomPosition)) > 0 || this.molPi.getMaximumBondOrder(atomi) != IBond.Order.SINGLE || atomi.getFormalCharge() != 0) {
                return this.gasteigerFactors[1][start] + q * this.gasteigerFactors[1][start + 1] + this.gasteigerFactors[1][start + 2] * (q * q);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return electronegativity;
    }

    @TestMethod(value="testSetMaxIterations_Int")
    public void setMaxIterations(int maxIterations) {
        this.maxI = maxIterations;
    }

    @TestMethod(value="testSetMaxResonStruc_Int")
    public void setMaxResonStruc(int maxResonStruc) {
        this.maxRS = maxResonStruc;
    }

    @TestMethod(value="testGetMaxIterations")
    public int getMaxIterations() {
        return this.maxI;
    }

    @TestMethod(value="testGetMaxResonStruc")
    public int getMaxResonStruc() {
        return this.maxRS;
    }
}

