/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.beam.CharBuffer;

public enum Element {
    Unknown(0, "*", 0),
    Hydrogen(1, "H"),
    Helium(2, "He"),
    Lithium(3, "Li"),
    Beryllium(4, "Be"),
    Boron(5, "B", 3),
    Carbon(6, "C", 4),
    Nitrogen(7, "N", 3, 5),
    Oxygen(8, "O", 2),
    Fluorine(9, "F", 1),
    Neon(10, "Ne"),
    Sodium(11, "Na"),
    Magnesium(12, "Mg"),
    Aluminum(13, "Al"),
    Silicon(14, "Si"),
    Phosphorus(15, "P", 3, 5),
    Sulfur(16, "S", 2, 4, 6),
    Chlorine(17, "Cl", 1),
    Argon(18, "Ar"),
    Potassium(19, "K"),
    Calcium(20, "Ca"),
    Scandium(21, "Sc"),
    Titanium(22, "Ti"),
    Vanadium(23, "V"),
    Chromium(24, "Cr"),
    Manganese(25, "Mn"),
    Iron(26, "Fe"),
    Cobalt(27, "Co"),
    Nickel(28, "Ni"),
    Copper(29, "Cu"),
    Zinc(30, "Zn"),
    Gallium(31, "Ga"),
    Germanium(32, "Ge"),
    Arsenic(33, "As"),
    Selenium(34, "Se"),
    Bromine(35, "Br", 1),
    Krypton(36, "Kr"),
    Rubidium(37, "Rb"),
    Strontium(38, "Sr"),
    Yttrium(39, "Y"),
    Zirconium(40, "Zr"),
    Niobium(41, "Nb"),
    Molybdenum(42, "Mo"),
    Technetium(43, "Tc"),
    Ruthenium(44, "Ru"),
    Rhodium(45, "Rh"),
    Palladium(46, "Pd"),
    Silver(47, "Ag"),
    Cadmium(48, "Cd"),
    Indium(49, "In"),
    Tin(50, "Sn"),
    Antimony(51, "Sb"),
    Tellurium(52, "Te"),
    Iodine(53, "I", 1),
    Xenon(54, "Xe"),
    Cesium(55, "Cs"),
    Barium(56, "Ba"),
    Lutetium(71, "Lu"),
    Hafnium(72, "Hf"),
    Tantalum(73, "Ta"),
    Tungsten(74, "W"),
    Rhenium(75, "Re"),
    Osmium(76, "Os"),
    Iridium(77, "Ir"),
    Platinum(78, "Pt"),
    Gold(79, "Au"),
    Mercury(80, "Hg"),
    Thallium(81, "Tl"),
    Lead(82, "Pb"),
    Bismuth(83, "Bi"),
    Polonium(84, "Po"),
    Astatine(85, "At"),
    Radon(86, "Rn"),
    Francium(87, "Fr"),
    Radium(88, "Ra"),
    Lawrencium(103, "Lr"),
    Rutherfordium(104, "Rf"),
    Dubnium(105, "Db"),
    Seaborgium(106, "Sg"),
    Bohrium(107, "Bh"),
    Hassium(108, "Hs"),
    Meitnerium(109, "Mt"),
    Darmstadtium(110, "Ds"),
    Roentgenium(111, "Rg"),
    Copernicium(112, "Cn"),
    Flerovium(114, "Fl"),
    Livermorium(116, "Lv"),
    Lanthanum(57, "La"),
    Cerium(58, "Ce"),
    Praseodymium(59, "Pr"),
    Neodymium(60, "Nd"),
    Promethium(61, "Pm"),
    Samarium(62, "Sm"),
    Europium(63, "Eu"),
    Gadolinium(64, "Gd"),
    Terbium(65, "Tb"),
    Dysprosium(66, "Dy"),
    Holmium(67, "Ho"),
    Erbium(68, "Er"),
    Thulium(69, "Tm"),
    Ytterbium(70, "Yb"),
    Actinium(89, "Ac"),
    Thorium(90, "Th"),
    Protactinium(91, "Pa"),
    Uranium(92, "U"),
    Neptunium(93, "Np"),
    Plutonium(94, "Pu"),
    Americium(95, "Am"),
    Curium(96, "Cm"),
    Berkelium(97, "Bk"),
    Californium(98, "Cf"),
    Einsteinium(99, "Es"),
    Fermium(100, "Fm"),
    Mendelevium(101, "Md"),
    Nobelium(102, "No");

    private final int atomicNumber;
    private final String symbol;
    private final int[] valence;
    private final int[] electrons;
    private static final Map<String, Element> elementMap;
    private static final Element[] elements;
    private ElementCheck defaults = ElementCheck.access$000();

    private Element(int atomicNumber, String symbol) {
        this(atomicNumber, symbol, null);
    }

    private Element(int atomicNumber, String symbol, int ... valence) {
        this.atomicNumber = atomicNumber;
        this.symbol = symbol;
        this.valence = valence;
        if (valence != null) {
            this.electrons = new int[valence.length];
            for (int i = 0; i < valence.length; ++i) {
                this.electrons[i] = valence[i] * 2;
            }
        } else {
            this.electrons = null;
        }
    }

    public String symbol() {
        return this.symbol;
    }

    public int atomicNumber() {
        return this.atomicNumber;
    }

    boolean aromatic() {
        return this.aromatic(AromaticSpecification.General);
    }

    boolean aromatic(AromaticSpecification spec) {
        return spec.contains(this);
    }

    boolean organic() {
        return this.valence != null;
    }

    @Deprecated
    int implicitHydrogens(int v) {
        return Element.implicitHydrogenCount(this, v);
    }

    @Deprecated
    int aromaticImplicitHydrogens(int v) {
        return Element.implicitAromHydrogenCount(this, v);
    }

    int availableElectrons(int bondElectronSum) {
        for (int e : this.electrons) {
            if (bondElectronSum > e) continue;
            return e - bondElectronSum;
        }
        return 0;
    }

    int availableDelocalisedElectrons(int bondElectronSum) {
        if (bondElectronSum <= this.electrons[0]) {
            return this.electrons[0] - bondElectronSum;
        }
        return 0;
    }

    boolean verify(int v, int q) {
        return this.defaults.verify(v, q);
    }

    public static Element ofSymbol(String symbol) {
        return elementMap.get(symbol);
    }

    public static Element ofNumber(int elem) {
        return elements[elem];
    }

    static Element read(CharBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        char c = buffer.get();
        if (buffer.hasRemaining() && buffer.next() >= 'a' && buffer.next() <= 'z') {
            return elementMap.get(new String(new char[]{c, buffer.get()}));
        }
        return elementMap.get(Character.toString(c));
    }

    static Map<String, ElementCheck> loadDefaults() {
        HashMap<String, ElementCheck> checks = new HashMap<String, ElementCheck>(200);
        try {
            InputStream in = Element.class.getResourceAsStream("element-defaults.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '-') continue;
                Map.Entry<String, ElementCheck> entry = Element.load(line);
                checks.put(entry.getKey(), entry.getValue());
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("error whilst loading element-defaults.txt: " + e);
        }
        return checks;
    }

    static Map.Entry<String, ElementCheck> load(String line) {
        String[] data = line.split("\\s+");
        String symbol = data[0];
        int electrons = Integer.parseInt(data[3]);
        ValenceCheck valenceCheck = ValenceCheck.parse(data[1], electrons);
        ChargeCheck chargeCheck = ChargeCheck.parse(data[2]);
        return new AbstractMap.SimpleEntry<String, ElementCheck>(symbol, new ElementCheck(valenceCheck, chargeCheck));
    }

    static int implicitHydrogenCount(Element elem, int v) {
        switch (elem) {
            case Boron: {
                if (v >= 3) break;
                return 3 - v;
            }
            case Carbon: {
                if (v >= 4) break;
                return 4 - v;
            }
            case Nitrogen: 
            case Phosphorus: {
                if (v <= 3) {
                    return 3 - v;
                }
                if (v >= 5) break;
                return 5 - v;
            }
            case Oxygen: {
                if (v >= 2) break;
                return 2 - v;
            }
            case Sulfur: {
                if (v <= 2) {
                    return 2 - v;
                }
                if (v <= 4) {
                    return 4 - v;
                }
                if (v >= 6) break;
                return 6 - v;
            }
            case Chlorine: 
            case Bromine: 
            case Iodine: 
            case Fluorine: {
                if (v >= 1) break;
                return 1;
            }
        }
        return 0;
    }

    static int implicitAromHydrogenCount(Element elem, int v) {
        switch (elem) {
            case Boron: {
                if (v >= 3) break;
                return 3 - v;
            }
            case Carbon: {
                if (v >= 4) break;
                return 4 - v;
            }
            case Nitrogen: 
            case Phosphorus: {
                if (v >= 3) break;
                return 3 - v;
            }
            case Oxygen: {
                if (v >= 2) break;
                return 2 - v;
            }
            case Sulfur: {
                if (v >= 2) break;
                return 2 - v;
            }
        }
        return 0;
    }

    static {
        elementMap = new HashMap<String, Element>();
        elements = new Element[117];
        for (Element element : Element.values()) {
            elementMap.put(element.symbol().toLowerCase(), element);
            elementMap.put(element.symbol(), element);
            Element.elements[element.atomicNumber] = element;
        }
        for (Map.Entry entry : Element.loadDefaults().entrySet()) {
            Element.elementMap.get(entry.getKey()).defaults = (ElementCheck)entry.getValue();
        }
    }

    static enum AromaticSpecification {
        Daylight(Unknown, Carbon, Nitrogen, Oxygen, Sulfur, Phosphorus, Arsenic, Selenium),
        OpenSmiles(Unknown, Boron, Carbon, Nitrogen, Oxygen, Sulfur, Phosphorus, Arsenic, Selenium),
        General(Unknown, Boron, Carbon, Nitrogen, Oxygen, Sulfur, Phosphorus, Arsenic, Selenium, Silicon, Germanium, Tin, Antimony, Tellurium, Bismuth);

        private EnumSet<Element> elements = EnumSet.noneOf(Element.class);

        private AromaticSpecification(Element ... es) {
            for (Element e : es) {
                this.elements.add(e);
            }
        }

        boolean contains(Element e) {
            return this.elements.contains((Object)e);
        }
    }

    private static final class ChargeCheck {
        private final int lo;
        private final int hi;
        private static final ChargeCheck NONE = new ChargeCheck(Integer.MIN_VALUE, Integer.MAX_VALUE);

        private ChargeCheck(int lo, int hi) {
            this.lo = lo;
            this.hi = hi;
        }

        boolean verify(int q) {
            return this.lo <= q && q <= this.hi;
        }

        static ChargeCheck parse(String range) {
            if (range.equals("n/a")) {
                return NONE;
            }
            String[] data = range.split(",");
            int lo = Integer.parseInt(data[0]);
            int hi = Integer.parseInt(data[1]);
            return new ChargeCheck(lo, hi);
        }

        public String toString() {
            return this.lo + " < q < " + this.hi;
        }

        static /* synthetic */ ChargeCheck access$300() {
            return NONE;
        }
    }

    private static final class NoValenceCheck
    extends ValenceCheck {
        private static final ValenceCheck INSTANCE = new NoValenceCheck();

        private NoValenceCheck() {
        }

        @Override
        boolean verify(int v, int q) {
            return true;
        }
    }

    private static final class MultiValenceCheck
    extends ValenceCheck {
        private final ValenceCheck[] valences;

        private MultiValenceCheck(ValenceCheck[] valences) {
            this.valences = valences;
        }

        @Override
        public boolean verify(int v, int q) {
            for (ValenceCheck vc : this.valences) {
                if (!vc.verify(v, q)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.valences);
        }
    }

    private static final class FixedValence
    extends ValenceCheck {
        private final int valence;

        private FixedValence(int valence) {
            this.valence = valence;
        }

        @Override
        public boolean verify(int v, int q) {
            return this.valence == v;
        }

        public String toString() {
            return "Fixed(" + this.valence + ")";
        }
    }

    private static final class NeutralValence
    extends ValenceCheck {
        private final int valence;

        private NeutralValence(int valence) {
            this.valence = valence;
        }

        @Override
        public boolean verify(int v, int q) {
            return q == 0 && v == this.valence;
        }

        public String toString() {
            return "Neutral(" + this.valence + ")";
        }
    }

    private static final class ChargeAdjustedValence
    extends ValenceCheck {
        private final int valence;
        private final int nElectrons;

        private ChargeAdjustedValence(int valence, int nElectrons) {
            this.valence = valence;
            this.nElectrons = nElectrons;
        }

        @Override
        public boolean verify(int v, int q) {
            if (this.nElectrons == 2 && this.valence + q > this.nElectrons - q) {
                return v == this.nElectrons - q;
            }
            return this.valence + q == v;
        }

        public String toString() {
            return "Charge(" + this.valence + ")";
        }
    }

    private static abstract class ValenceCheck {
        private ValenceCheck() {
        }

        abstract boolean verify(int var1, int var2);

        static ValenceCheck parse(String line, int nElectrons) {
            String[] vs = line.split(",");
            if (vs.length == 1) {
                if (vs[0].equals("n/a")) {
                    return NoValenceCheck.INSTANCE;
                }
                if (vs[0].charAt(0) == '(') {
                    return new FixedValence(Integer.parseInt(vs[0].substring(1, vs[0].length() - 1)));
                }
                if (vs[0].charAt(0) == '[') {
                    return new NeutralValence(Integer.parseInt(vs[0].substring(1, vs[0].length() - 1)));
                }
                return new ChargeAdjustedValence(Integer.parseInt(vs[0]), nElectrons);
            }
            ValenceCheck[] valences = new ValenceCheck[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                valences[i] = ValenceCheck.parse(vs[i], nElectrons);
            }
            return new MultiValenceCheck(valences);
        }
    }

    private static final class ElementCheck {
        private final ValenceCheck valenceCheck;
        private final ChargeCheck chargeCheck;
        private static final ElementCheck NO_CHECK = new ElementCheck(NoValenceCheck.access$200(), ChargeCheck.access$300());

        private ElementCheck(ValenceCheck valenceCheck, ChargeCheck chargeCheck) {
            this.valenceCheck = valenceCheck;
            this.chargeCheck = chargeCheck;
        }

        boolean verify(int v, int q) {
            return this.chargeCheck.verify(q) && this.valenceCheck.verify(v, q);
        }

        public String toString() {
            return this.chargeCheck + ", " + this.valenceCheck;
        }

        static /* synthetic */ ElementCheck access$000() {
            return NO_CHECK;
        }
    }
}

